/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.PrivacyRule;
import telegram4j.tl.User;
import telegram4j.tl.account.PrivacyRules;
import telegram4j.tl.api.TlObject;

public final class ImmutablePrivacyRules
implements PrivacyRules {
    private final int identifier;
    private final List<PrivacyRule> rules;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutablePrivacyRules(Builder builder) {
        this.rules = ImmutablePrivacyRules.createUnmodifiableList(true, builder.rules);
        this.chats = ImmutablePrivacyRules.createUnmodifiableList(true, builder.chats);
        this.users = ImmutablePrivacyRules.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PrivacyRules.super.identifier();
    }

    private ImmutablePrivacyRules(int identifier, List<PrivacyRule> rules, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.rules = rules;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<PrivacyRule> rules() {
        return this.rules;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePrivacyRules withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePrivacyRules(value, this.rules, this.chats, this.users);
    }

    public final ImmutablePrivacyRules withRules(PrivacyRule ... elements) {
        List<PrivacyRule> newValue = ImmutablePrivacyRules.createUnmodifiableList(false, ImmutablePrivacyRules.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePrivacyRules(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutablePrivacyRules withRules(Iterable<? extends PrivacyRule> elements) {
        if (this.rules == elements) {
            return this;
        }
        List<PrivacyRule> newValue = ImmutablePrivacyRules.createUnmodifiableList(false, ImmutablePrivacyRules.createSafeList(elements, true, false));
        return new ImmutablePrivacyRules(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutablePrivacyRules withChats(Chat ... elements) {
        List<Chat> newValue = ImmutablePrivacyRules.createUnmodifiableList(false, ImmutablePrivacyRules.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePrivacyRules(this.identifier, this.rules, newValue, this.users);
    }

    public final ImmutablePrivacyRules withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutablePrivacyRules.createUnmodifiableList(false, ImmutablePrivacyRules.createSafeList(elements, true, false));
        return new ImmutablePrivacyRules(this.identifier, this.rules, newValue, this.users);
    }

    public final ImmutablePrivacyRules withUsers(User ... elements) {
        List<User> newValue = ImmutablePrivacyRules.createUnmodifiableList(false, ImmutablePrivacyRules.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePrivacyRules(this.identifier, this.rules, this.chats, newValue);
    }

    public final ImmutablePrivacyRules withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePrivacyRules.createUnmodifiableList(false, ImmutablePrivacyRules.createSafeList(elements, true, false));
        return new ImmutablePrivacyRules(this.identifier, this.rules, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePrivacyRules && this.equalTo(0, (ImmutablePrivacyRules)another);
    }

    private boolean equalTo(int synthetic, ImmutablePrivacyRules another) {
        return this.identifier == another.identifier && this.rules.equals(another.rules) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.rules.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PrivacyRules{identifier=" + this.identifier + ", rules=" + this.rules + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutablePrivacyRules copyOf(PrivacyRules instance) {
        if (instance instanceof ImmutablePrivacyRules) {
            return (ImmutablePrivacyRules)instance;
        }
        return ImmutablePrivacyRules.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<PrivacyRule> rules = new ArrayList<PrivacyRule>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(PrivacyRules instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PrivacyRules instance;
            long bits = 0L;
            if (object instanceof PrivacyRules) {
                instance = (PrivacyRules)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllRules(instance.rules());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addRule(PrivacyRule element) {
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder addRules(PrivacyRule ... elements) {
            for (PrivacyRule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(Iterable<? extends PrivacyRule> elements) {
            this.rules.clear();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends PrivacyRule> elements) {
            for (PrivacyRule privacyRule : elements) {
                this.rules.add(Objects.requireNonNull(privacyRule, "rules element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePrivacyRules build() {
            return new ImmutablePrivacyRules(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

