/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.account.ResetPasswordFailedWait;
import telegram4j.tl.account.ResetPasswordResult;
import telegram4j.tl.api.TlObject;

public final class ImmutableResetPasswordFailedWait
implements ResetPasswordFailedWait {
    private final int identifier;
    private final int retryDate;

    private ImmutableResetPasswordFailedWait(int retryDate) {
        this.retryDate = retryDate;
        this.identifier = ResetPasswordFailedWait.super.identifier();
    }

    private ImmutableResetPasswordFailedWait(Builder builder) {
        this.retryDate = builder.retryDate;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResetPasswordFailedWait.super.identifier();
    }

    private ImmutableResetPasswordFailedWait(int identifier, int retryDate) {
        this.identifier = identifier;
        this.retryDate = retryDate;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int retryDate() {
        return this.retryDate;
    }

    public final ImmutableResetPasswordFailedWait withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResetPasswordFailedWait(value, this.retryDate);
    }

    public final ImmutableResetPasswordFailedWait withRetryDate(int value) {
        if (this.retryDate == value) {
            return this;
        }
        return new ImmutableResetPasswordFailedWait(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResetPasswordFailedWait && this.equalTo(0, (ImmutableResetPasswordFailedWait)another);
    }

    private boolean equalTo(int synthetic, ImmutableResetPasswordFailedWait another) {
        return this.identifier == another.identifier && this.retryDate == another.retryDate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.retryDate;
        return h;
    }

    public String toString() {
        return "ResetPasswordFailedWait{identifier=" + this.identifier + ", retryDate=" + this.retryDate + "}";
    }

    public static ImmutableResetPasswordFailedWait of(int retryDate) {
        return new ImmutableResetPasswordFailedWait(retryDate);
    }

    public static ImmutableResetPasswordFailedWait copyOf(ResetPasswordFailedWait instance) {
        if (instance instanceof ImmutableResetPasswordFailedWait) {
            return (ImmutableResetPasswordFailedWait)instance;
        }
        return ImmutableResetPasswordFailedWait.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RETRY_DATE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int retryDate;

        private Builder() {
        }

        public final Builder from(ResetPasswordFailedWait instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResetPasswordResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResetPasswordResult instance;
            long bits = 0L;
            if (object instanceof ResetPasswordFailedWait) {
                instance = (ResetPasswordFailedWait)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.retryDate(instance.retryDate());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ResetPasswordResult) {
                instance = (ResetPasswordResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder retryDate(int retryDate) {
            this.retryDate = retryDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableResetPasswordFailedWait build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResetPasswordFailedWait(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("retryDate");
            }
            return "Cannot build ResetPasswordFailedWait, some of required attributes are not set " + attributes;
        }
    }
}

