/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.account.SavedRingtone;
import telegram4j.tl.account.SavedRingtoneConverted;
import telegram4j.tl.api.TlObject;

public final class ImmutableSavedRingtoneConverted
implements SavedRingtoneConverted {
    private final int identifier;
    private final Document document;

    private ImmutableSavedRingtoneConverted(Document document) {
        this.document = Objects.requireNonNull(document, "document");
        this.identifier = SavedRingtoneConverted.super.identifier();
    }

    private ImmutableSavedRingtoneConverted(Builder builder) {
        this.document = builder.document;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SavedRingtoneConverted.super.identifier();
    }

    private ImmutableSavedRingtoneConverted(int identifier, Document document) {
        this.identifier = identifier;
        this.document = document;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Document document() {
        return this.document;
    }

    public final ImmutableSavedRingtoneConverted withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSavedRingtoneConverted(value, this.document);
    }

    public final ImmutableSavedRingtoneConverted withDocument(Document value) {
        if (this.document == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "document");
        return new ImmutableSavedRingtoneConverted(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSavedRingtoneConverted && this.equalTo(0, (ImmutableSavedRingtoneConverted)another);
    }

    private boolean equalTo(int synthetic, ImmutableSavedRingtoneConverted another) {
        return this.identifier == another.identifier && this.document.equals(another.document);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.document.hashCode();
        return h;
    }

    public String toString() {
        return "SavedRingtoneConverted{identifier=" + this.identifier + ", document=" + this.document + "}";
    }

    public static ImmutableSavedRingtoneConverted of(Document document) {
        return new ImmutableSavedRingtoneConverted(document);
    }

    public static ImmutableSavedRingtoneConverted copyOf(SavedRingtoneConverted instance) {
        if (instance instanceof ImmutableSavedRingtoneConverted) {
            return (ImmutableSavedRingtoneConverted)instance;
        }
        return ImmutableSavedRingtoneConverted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOCUMENT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Document document;

        private Builder() {
        }

        public final Builder from(SavedRingtoneConverted instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SavedRingtone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SavedRingtone instance;
            long bits = 0L;
            if (object instanceof SavedRingtoneConverted) {
                instance = (SavedRingtoneConverted)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.document(instance.document());
            }
            if (object instanceof SavedRingtone) {
                instance = (SavedRingtone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder document(Document document) {
            this.document = Objects.requireNonNull(document, "document");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSavedRingtoneConverted build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSavedRingtoneConverted(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("document");
            }
            return "Cannot build SavedRingtoneConverted, some of required attributes are not set " + attributes;
        }
    }
}

