/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.account.SentEmailCode;
import telegram4j.tl.api.TlObject;

public final class ImmutableSentEmailCode
implements SentEmailCode {
    private final int identifier;
    private final String emailPattern;
    private final int length;

    private ImmutableSentEmailCode(String emailPattern, int length) {
        this.emailPattern = Objects.requireNonNull(emailPattern, "emailPattern");
        this.length = length;
        this.identifier = SentEmailCode.super.identifier();
    }

    private ImmutableSentEmailCode(Builder builder) {
        this.emailPattern = builder.emailPattern;
        this.length = builder.length;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SentEmailCode.super.identifier();
    }

    private ImmutableSentEmailCode(int identifier, String emailPattern, int length) {
        this.identifier = identifier;
        this.emailPattern = emailPattern;
        this.length = length;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emailPattern() {
        return this.emailPattern;
    }

    @Override
    public int length() {
        return this.length;
    }

    public final ImmutableSentEmailCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentEmailCode(value, this.emailPattern, this.length);
    }

    public final ImmutableSentEmailCode withEmailPattern(String value) {
        String newValue = Objects.requireNonNull(value, "emailPattern");
        if (this.emailPattern.equals(newValue)) {
            return this;
        }
        return new ImmutableSentEmailCode(this.identifier, newValue, this.length);
    }

    public final ImmutableSentEmailCode withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableSentEmailCode(this.identifier, this.emailPattern, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentEmailCode && this.equalTo(0, (ImmutableSentEmailCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentEmailCode another) {
        return this.identifier == another.identifier && this.emailPattern.equals(another.emailPattern) && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emailPattern.hashCode();
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return "SentEmailCode{identifier=" + this.identifier + ", emailPattern=" + this.emailPattern + ", length=" + this.length + "}";
    }

    public static ImmutableSentEmailCode of(String emailPattern, int length) {
        return new ImmutableSentEmailCode(emailPattern, length);
    }

    public static ImmutableSentEmailCode copyOf(SentEmailCode instance) {
        if (instance instanceof ImmutableSentEmailCode) {
            return (ImmutableSentEmailCode)instance;
        }
        return ImmutableSentEmailCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMAIL_PATTERN = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String emailPattern;
        private int length;

        private Builder() {
        }

        public final Builder from(SentEmailCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SentEmailCode instance;
            long bits = 0L;
            if (object instanceof SentEmailCode) {
                instance = (SentEmailCode)object;
                this.emailPattern(instance.emailPattern());
                this.length(instance.length());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emailPattern(String emailPattern) {
            this.emailPattern = Objects.requireNonNull(emailPattern, "emailPattern");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSentEmailCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentEmailCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emailPattern");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build SentEmailCode, some of required attributes are not set " + attributes;
        }
    }
}

