/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.account.Takeout;
import telegram4j.tl.api.TlObject;

public final class ImmutableTakeout
implements Takeout {
    private final int identifier;
    private final long id;

    private ImmutableTakeout(long id) {
        this.id = id;
        this.identifier = Takeout.super.identifier();
    }

    private ImmutableTakeout(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Takeout.super.identifier();
    }

    private ImmutableTakeout(int identifier, long id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    public final ImmutableTakeout withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTakeout(value, this.id);
    }

    public final ImmutableTakeout withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableTakeout(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTakeout && this.equalTo(0, (ImmutableTakeout)another);
    }

    private boolean equalTo(int synthetic, ImmutableTakeout another) {
        return this.identifier == another.identifier && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        return h;
    }

    public String toString() {
        return "Takeout{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableTakeout of(long id) {
        return new ImmutableTakeout(id);
    }

    public static ImmutableTakeout copyOf(Takeout instance) {
        if (instance instanceof ImmutableTakeout) {
            return (ImmutableTakeout)instance;
        }
        return ImmutableTakeout.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long id;

        private Builder() {
        }

        public final Builder from(Takeout instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Takeout instance;
            long bits = 0L;
            if (object instanceof Takeout) {
                instance = (Takeout)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTakeout build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTakeout(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Takeout, some of required attributes are not set " + attributes;
        }
    }
}

