/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.account.TmpPassword;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableTmpPassword
implements TmpPassword {
    private final int identifier;
    private final ByteBuf tmpPassword;
    private final int validUntil;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTmpPassword(int validUntil) {
        this.validUntil = validUntil;
        this.tmpPassword = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableTmpPassword(Builder builder) {
        this.tmpPassword = builder.tmpPassword_build();
        this.validUntil = builder.validUntil;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableTmpPassword(int identifier, ByteBuf tmpPassword, int validUntil) {
        this.identifier = identifier;
        this.tmpPassword = tmpPassword;
        this.validUntil = validUntil;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return TmpPassword.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf tmpPassword() {
        return this.tmpPassword.duplicate();
    }

    @Override
    public int validUntil() {
        return this.validUntil;
    }

    public final ImmutableTmpPassword withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTmpPassword(value, this.tmpPassword, this.validUntil);
    }

    public ImmutableTmpPassword withTmpPassword(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.tmpPassword == newValue) {
            return this;
        }
        return new ImmutableTmpPassword(this.identifier, newValue, this.validUntil);
    }

    public final ImmutableTmpPassword withValidUntil(int value) {
        if (this.validUntil == value) {
            return this;
        }
        return new ImmutableTmpPassword(this.identifier, this.tmpPassword, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTmpPassword && this.equalTo(0, (ImmutableTmpPassword)another);
    }

    private boolean equalTo(int synthetic, ImmutableTmpPassword another) {
        return this.identifier == another.identifier && this.tmpPassword().equals((Object)another.tmpPassword()) && this.validUntil == another.validUntil;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.tmpPassword().hashCode();
        h += (h << 5) + this.validUntil;
        return h;
    }

    public String toString() {
        return "TmpPassword{identifier=" + this.identifier + ", tmpPassword=" + ByteBufUtil.hexDump((ByteBuf)this.tmpPassword) + ", validUntil=" + this.validUntil + "}";
    }

    public static ImmutableTmpPassword of(int validUntil) {
        return new ImmutableTmpPassword(validUntil);
    }

    public static ImmutableTmpPassword copyOf(TmpPassword instance) {
        if (instance instanceof ImmutableTmpPassword) {
            return (ImmutableTmpPassword)instance;
        }
        return ImmutableTmpPassword.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VALID_UNTIL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf tmpPassword_value = null;
        private int identifier;
        private int validUntil;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TmpPassword instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TmpPassword) {
                instance = (TmpPassword)object;
                this.tmpPassword(instance.tmpPassword());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.validUntil(instance.validUntil());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder tmpPassword(ByteBuf value) {
            this.tmpPassword_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder validUntil(int validUntil) {
            this.validUntil = validUntil;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTmpPassword build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTmpPassword(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("validUntil");
            }
            return "Cannot build TmpPassword, some of required attributes are not set " + attributes;
        }

        private ByteBuf tmpPassword_build() {
            return Objects.requireNonNull(this.tmpPassword_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableTmpPassword.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build TmpPassword, attribute initializers form cycle " + attributes;
        }
    }
}

