/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.User;
import telegram4j.tl.WebAuthorization;
import telegram4j.tl.account.WebAuthorizations;
import telegram4j.tl.api.TlObject;

public final class ImmutableWebAuthorizations
implements WebAuthorizations {
    private final int identifier;
    private final List<WebAuthorization> authorizations;
    private final List<User> users;

    private ImmutableWebAuthorizations(Builder builder) {
        this.authorizations = ImmutableWebAuthorizations.createUnmodifiableList(true, builder.authorizations);
        this.users = ImmutableWebAuthorizations.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : WebAuthorizations.super.identifier();
    }

    private ImmutableWebAuthorizations(int identifier, List<WebAuthorization> authorizations, List<User> users) {
        this.identifier = identifier;
        this.authorizations = authorizations;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<WebAuthorization> authorizations() {
        return this.authorizations;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableWebAuthorizations withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableWebAuthorizations(value, this.authorizations, this.users);
    }

    public final ImmutableWebAuthorizations withAuthorizations(WebAuthorization ... elements) {
        List<WebAuthorization> newValue = ImmutableWebAuthorizations.createUnmodifiableList(false, ImmutableWebAuthorizations.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWebAuthorizations(this.identifier, newValue, this.users);
    }

    public final ImmutableWebAuthorizations withAuthorizations(Iterable<? extends WebAuthorization> elements) {
        if (this.authorizations == elements) {
            return this;
        }
        List<WebAuthorization> newValue = ImmutableWebAuthorizations.createUnmodifiableList(false, ImmutableWebAuthorizations.createSafeList(elements, true, false));
        return new ImmutableWebAuthorizations(this.identifier, newValue, this.users);
    }

    public final ImmutableWebAuthorizations withUsers(User ... elements) {
        List<User> newValue = ImmutableWebAuthorizations.createUnmodifiableList(false, ImmutableWebAuthorizations.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWebAuthorizations(this.identifier, this.authorizations, newValue);
    }

    public final ImmutableWebAuthorizations withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableWebAuthorizations.createUnmodifiableList(false, ImmutableWebAuthorizations.createSafeList(elements, true, false));
        return new ImmutableWebAuthorizations(this.identifier, this.authorizations, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebAuthorizations && this.equalTo(0, (ImmutableWebAuthorizations)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebAuthorizations another) {
        return this.identifier == another.identifier && this.authorizations.equals(another.authorizations) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.authorizations.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "WebAuthorizations{identifier=" + this.identifier + ", authorizations=" + this.authorizations + ", users=" + this.users + "}";
    }

    public static ImmutableWebAuthorizations copyOf(WebAuthorizations instance) {
        if (instance instanceof ImmutableWebAuthorizations) {
            return (ImmutableWebAuthorizations)instance;
        }
        return ImmutableWebAuthorizations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<WebAuthorization> authorizations = new ArrayList<WebAuthorization>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WebAuthorizations instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WebAuthorizations) {
                instance = (WebAuthorizations)object;
                this.addAllAuthorizations(instance.authorizations());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addAuthorization(WebAuthorization element) {
            this.authorizations.add(Objects.requireNonNull(element, "authorizations element"));
            return this;
        }

        public final Builder addAuthorizations(WebAuthorization ... elements) {
            for (WebAuthorization element : elements) {
                this.authorizations.add(Objects.requireNonNull(element, "authorizations element"));
            }
            return this;
        }

        public final Builder authorizations(Iterable<? extends WebAuthorization> elements) {
            this.authorizations.clear();
            return this.addAllAuthorizations(elements);
        }

        public final Builder addAllAuthorizations(Iterable<? extends WebAuthorization> elements) {
            for (WebAuthorization webAuthorization : elements) {
                this.authorizations.add(Objects.requireNonNull(webAuthorization, "authorizations element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableWebAuthorizations build() {
            return new ImmutableWebAuthorizations(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

