/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.Authorization;
import telegram4j.tl.auth.AuthorizationSignUpRequired;
import telegram4j.tl.help.TermsOfService;

public final class ImmutableAuthorizationSignUpRequired
implements AuthorizationSignUpRequired {
    private final int identifier;
    private final int flags;
    @Nullable
    private final TermsOfService termsOfService;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableAuthorizationSignUpRequired INSTANCE = ImmutableAuthorizationSignUpRequired.validate(new ImmutableAuthorizationSignUpRequired());

    private ImmutableAuthorizationSignUpRequired() {
        this.termsOfService = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableAuthorizationSignUpRequired(Builder builder) {
        this.termsOfService = builder.termsOfService;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableAuthorizationSignUpRequired(int identifier, int flags, @Nullable TermsOfService termsOfService) {
        this.identifier = identifier;
        this.flags = flags;
        this.termsOfService = termsOfService;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AuthorizationSignUpRequired.super.identifier();
    }

    private int flagsInitialize() {
        return AuthorizationSignUpRequired.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public TermsOfService termsOfService() {
        return this.termsOfService;
    }

    public final ImmutableAuthorizationSignUpRequired withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableAuthorizationSignUpRequired.validate(new ImmutableAuthorizationSignUpRequired(value, this.flags, this.termsOfService));
    }

    public final ImmutableAuthorizationSignUpRequired withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableAuthorizationSignUpRequired.validate(new ImmutableAuthorizationSignUpRequired(this.identifier, value, this.termsOfService));
    }

    public final ImmutableAuthorizationSignUpRequired withTermsOfService(@Nullable TermsOfService value) {
        if (this.termsOfService == value) {
            return this;
        }
        return ImmutableAuthorizationSignUpRequired.validate(new ImmutableAuthorizationSignUpRequired(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationSignUpRequired && this.equalTo(0, (ImmutableAuthorizationSignUpRequired)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationSignUpRequired another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.termsOfService, another.termsOfService);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.termsOfService);
        return h;
    }

    public String toString() {
        return "AuthorizationSignUpRequired{identifier=" + this.identifier + ", flags=" + this.flags + ", termsOfService=" + this.termsOfService + "}";
    }

    public static ImmutableAuthorizationSignUpRequired of() {
        return INSTANCE;
    }

    private static ImmutableAuthorizationSignUpRequired validate(ImmutableAuthorizationSignUpRequired instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableAuthorizationSignUpRequired copyOf(AuthorizationSignUpRequired instance) {
        if (instance instanceof ImmutableAuthorizationSignUpRequired) {
            return (ImmutableAuthorizationSignUpRequired)instance;
        }
        return ImmutableAuthorizationSignUpRequired.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private TermsOfService termsOfService;

        private Builder() {
        }

        public final Builder from(AuthorizationSignUpRequired instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Authorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Authorization instance;
            long bits = 0L;
            if (object instanceof AuthorizationSignUpRequired) {
                TermsOfService termsOfServiceValue;
                instance = (AuthorizationSignUpRequired)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((termsOfServiceValue = instance.termsOfService()) != null) {
                    this.termsOfService(termsOfServiceValue);
                }
            }
            if (object instanceof Authorization) {
                instance = (Authorization)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder termsOfService(@Nullable TermsOfService termsOfService) {
            this.termsOfService = termsOfService;
            return this;
        }

        public ImmutableAuthorizationSignUpRequired build() {
            return ImmutableAuthorizationSignUpRequired.validate(new ImmutableAuthorizationSignUpRequired(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAuthorizationSignUpRequired.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAuthorizationSignUpRequired.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build AuthorizationSignUpRequired, attribute initializers form cycle " + attributes;
        }
    }
}

