/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.Authorization;
import telegram4j.tl.auth.BaseAuthorization;

public final class ImmutableBaseAuthorization
implements BaseAuthorization {
    private final int identifier;
    private final int flags;
    private final boolean setupPasswordRequired;
    @Nullable
    private final Integer otherwiseReloginDays;
    @Nullable
    private final Integer tmpSessions;
    private final User user;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseAuthorization(User user) {
        this.user = Objects.requireNonNull(user, "user");
        this.otherwiseReloginDays = null;
        this.tmpSessions = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.setupPasswordRequired = this.initShim.setupPasswordRequired();
        this.initShim = null;
    }

    private ImmutableBaseAuthorization(Builder builder) {
        this.otherwiseReloginDays = builder.otherwiseReloginDays;
        this.tmpSessions = builder.tmpSessions;
        this.user = builder.user;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.setupPasswordRequiredIsSet()) {
            this.initShim.setupPasswordRequired(builder.setupPasswordRequired);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.setupPasswordRequired = this.initShim.setupPasswordRequired();
        this.initShim = null;
    }

    private ImmutableBaseAuthorization(int identifier, int flags, boolean setupPasswordRequired, @Nullable Integer otherwiseReloginDays, @Nullable Integer tmpSessions, User user) {
        this.identifier = identifier;
        this.flags = flags;
        this.setupPasswordRequired = setupPasswordRequired;
        this.otherwiseReloginDays = otherwiseReloginDays;
        this.tmpSessions = tmpSessions;
        this.user = user;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseAuthorization.super.identifier();
    }

    private int flagsInitialize() {
        return BaseAuthorization.super.flags();
    }

    private boolean setupPasswordRequiredInitialize() {
        return BaseAuthorization.super.setupPasswordRequired();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean setupPasswordRequired() {
        InitShim shim = this.initShim;
        return shim != null ? shim.setupPasswordRequired() : this.setupPasswordRequired;
    }

    @Override
    @Nullable
    public Integer otherwiseReloginDays() {
        return this.otherwiseReloginDays;
    }

    @Override
    @Nullable
    public Integer tmpSessions() {
        return this.tmpSessions;
    }

    @Override
    public User user() {
        return this.user;
    }

    public final ImmutableBaseAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseAuthorization(value, this.flags, this.setupPasswordRequired, this.otherwiseReloginDays, this.tmpSessions, this.user);
    }

    public final ImmutableBaseAuthorization withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseAuthorization(this.identifier, value, this.setupPasswordRequired, this.otherwiseReloginDays, this.tmpSessions, this.user);
    }

    public final ImmutableBaseAuthorization withSetupPasswordRequired(boolean value) {
        if (this.setupPasswordRequired == value) {
            return this;
        }
        return new ImmutableBaseAuthorization(this.identifier, this.flags, value, this.otherwiseReloginDays, this.tmpSessions, this.user);
    }

    public final ImmutableBaseAuthorization withOtherwiseReloginDays(@Nullable Integer value) {
        if (Objects.equals(this.otherwiseReloginDays, value)) {
            return this;
        }
        return new ImmutableBaseAuthorization(this.identifier, this.flags, this.setupPasswordRequired, value, this.tmpSessions, this.user);
    }

    public final ImmutableBaseAuthorization withTmpSessions(@Nullable Integer value) {
        if (Objects.equals(this.tmpSessions, value)) {
            return this;
        }
        return new ImmutableBaseAuthorization(this.identifier, this.flags, this.setupPasswordRequired, this.otherwiseReloginDays, value, this.user);
    }

    public final ImmutableBaseAuthorization withUser(User value) {
        if (this.user == value) {
            return this;
        }
        User newValue = Objects.requireNonNull(value, "user");
        return new ImmutableBaseAuthorization(this.identifier, this.flags, this.setupPasswordRequired, this.otherwiseReloginDays, this.tmpSessions, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseAuthorization && this.equalTo(0, (ImmutableBaseAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseAuthorization another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.setupPasswordRequired == another.setupPasswordRequired && Objects.equals(this.otherwiseReloginDays, another.otherwiseReloginDays) && Objects.equals(this.tmpSessions, another.tmpSessions) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.setupPasswordRequired);
        h += (h << 5) + Objects.hashCode(this.otherwiseReloginDays);
        h += (h << 5) + Objects.hashCode(this.tmpSessions);
        h += (h << 5) + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "BaseAuthorization{identifier=" + this.identifier + ", flags=" + this.flags + ", setupPasswordRequired=" + this.setupPasswordRequired + ", otherwiseReloginDays=" + this.otherwiseReloginDays + ", tmpSessions=" + this.tmpSessions + ", user=" + this.user + "}";
    }

    public static ImmutableBaseAuthorization of(User user) {
        return new ImmutableBaseAuthorization(user);
    }

    public static ImmutableBaseAuthorization copyOf(BaseAuthorization instance) {
        if (instance instanceof ImmutableBaseAuthorization) {
            return (ImmutableBaseAuthorization)instance;
        }
        return ImmutableBaseAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SETUP_PASSWORD_REQUIRED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean setupPasswordRequired;
        private Integer otherwiseReloginDays;
        private Integer tmpSessions;
        private User user;

        private Builder() {
        }

        public final Builder from(Authorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseAuthorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Authorization instance;
            long bits = 0L;
            if (object instanceof Authorization) {
                instance = (Authorization)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseAuthorization) {
                Integer tmpSessionsValue;
                instance = (BaseAuthorization)object;
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((tmpSessionsValue = instance.tmpSessions()) != null) {
                    this.tmpSessions(tmpSessionsValue);
                }
                this.user(instance.user());
                Integer otherwiseReloginDaysValue = instance.otherwiseReloginDays();
                if (otherwiseReloginDaysValue != null) {
                    this.otherwiseReloginDays(otherwiseReloginDaysValue);
                }
                this.setupPasswordRequired(instance.setupPasswordRequired());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setupPasswordRequired(boolean setupPasswordRequired) {
            this.setupPasswordRequired = setupPasswordRequired;
            this.optBits |= 4L;
            return this;
        }

        public final Builder otherwiseReloginDays(@Nullable Integer otherwiseReloginDays) {
            this.otherwiseReloginDays = otherwiseReloginDays;
            return this;
        }

        public final Builder tmpSessions(@Nullable Integer tmpSessions) {
            this.tmpSessions = tmpSessions;
            return this;
        }

        public final Builder user(User user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean setupPasswordRequiredIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build BaseAuthorization, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte setupPasswordRequiredBuildStage = 0;
        private boolean setupPasswordRequired;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseAuthorization.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseAuthorization.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean setupPasswordRequired() {
            if (this.setupPasswordRequiredBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.setupPasswordRequiredBuildStage == 0) {
                this.setupPasswordRequiredBuildStage = (byte)-1;
                this.setupPasswordRequired = ImmutableBaseAuthorization.this.setupPasswordRequiredInitialize();
                this.setupPasswordRequiredBuildStage = 1;
            }
            return this.setupPasswordRequired;
        }

        void setupPasswordRequired(boolean setupPasswordRequired) {
            this.setupPasswordRequired = setupPasswordRequired;
            this.setupPasswordRequiredBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.setupPasswordRequiredBuildStage == -1) {
                attributes.add("setupPasswordRequired");
            }
            return "Cannot build BaseAuthorization, attribute initializers form cycle " + attributes;
        }
    }
}

