/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.BaseLoginToken;
import telegram4j.tl.auth.LoginToken;

public final class ImmutableBaseLoginToken
implements BaseLoginToken {
    private final int identifier;
    private final int expires;
    private final ByteBuf token;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseLoginToken(int expires) {
        this.expires = expires;
        this.token = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseLoginToken(Builder builder) {
        this.expires = builder.expires;
        this.token = builder.token_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseLoginToken(int identifier, int expires, ByteBuf token) {
        this.identifier = identifier;
        this.expires = expires;
        this.token = token;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseLoginToken.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    @Override
    public ByteBuf token() {
        return this.token.duplicate();
    }

    public final ImmutableBaseLoginToken withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseLoginToken(value, this.expires, this.token);
    }

    public final ImmutableBaseLoginToken withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableBaseLoginToken(this.identifier, value, this.token);
    }

    public ImmutableBaseLoginToken withToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.token == newValue) {
            return this;
        }
        return new ImmutableBaseLoginToken(this.identifier, this.expires, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseLoginToken && this.equalTo(0, (ImmutableBaseLoginToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseLoginToken another) {
        return this.identifier == another.identifier && this.expires == another.expires && this.token().equals((Object)another.token());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.expires;
        h += (h << 5) + this.token().hashCode();
        return h;
    }

    public String toString() {
        return "BaseLoginToken{identifier=" + this.identifier + ", expires=" + this.expires + ", token=" + ByteBufUtil.hexDump((ByteBuf)this.token) + "}";
    }

    public static ImmutableBaseLoginToken of(int expires) {
        return new ImmutableBaseLoginToken(expires);
    }

    public static ImmutableBaseLoginToken copyOf(BaseLoginToken instance) {
        if (instance instanceof ImmutableBaseLoginToken) {
            return (ImmutableBaseLoginToken)instance;
        }
        return ImmutableBaseLoginToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXPIRES = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf token_value = null;
        private int identifier;
        private int expires;

        private Builder() {
        }

        public final Builder from(LoginToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseLoginToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LoginToken instance;
            long bits = 0L;
            if (object instanceof LoginToken) {
                instance = (LoginToken)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseLoginToken) {
                instance = (BaseLoginToken)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.expires(instance.expires());
                this.token(instance.token());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder token(ByteBuf value) {
            this.token_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBaseLoginToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseLoginToken(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expires");
            }
            return "Cannot build BaseLoginToken, some of required attributes are not set " + attributes;
        }

        private ByteBuf token_build() {
            return Objects.requireNonNull(this.token_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseLoginToken.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseLoginToken, attribute initializers form cycle " + attributes;
        }
    }
}

