/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.ExportedAuthorization;

public final class ImmutableExportedAuthorization
implements ExportedAuthorization {
    private final int identifier;
    private final long id;
    private final ByteBuf bytes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExportedAuthorization(long id) {
        this.id = id;
        this.bytes = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableExportedAuthorization(Builder builder) {
        this.id = builder.id;
        this.bytes = builder.bytes_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableExportedAuthorization(int identifier, long id, ByteBuf bytes) {
        this.identifier = identifier;
        this.id = id;
        this.bytes = bytes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ExportedAuthorization.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public ByteBuf bytes() {
        return this.bytes.duplicate();
    }

    public final ImmutableExportedAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportedAuthorization(value, this.id, this.bytes);
    }

    public final ImmutableExportedAuthorization withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableExportedAuthorization(this.identifier, value, this.bytes);
    }

    public ImmutableExportedAuthorization withBytes(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.bytes == newValue) {
            return this;
        }
        return new ImmutableExportedAuthorization(this.identifier, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportedAuthorization && this.equalTo(0, (ImmutableExportedAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportedAuthorization another) {
        return this.identifier == another.identifier && this.id == another.id && this.bytes().equals((Object)another.bytes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.bytes().hashCode();
        return h;
    }

    public String toString() {
        return "ExportedAuthorization{identifier=" + this.identifier + ", id=" + this.id + ", bytes=" + ByteBufUtil.hexDump((ByteBuf)this.bytes) + "}";
    }

    public static ImmutableExportedAuthorization of(long id) {
        return new ImmutableExportedAuthorization(id);
    }

    public static ImmutableExportedAuthorization copyOf(ExportedAuthorization instance) {
        if (instance instanceof ImmutableExportedAuthorization) {
            return (ImmutableExportedAuthorization)instance;
        }
        return ImmutableExportedAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf bytes_value = null;
        private int identifier;
        private long id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExportedAuthorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ExportedAuthorization) {
                instance = (ExportedAuthorization)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.bytes(instance.bytes());
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder bytes(ByteBuf value) {
            this.bytes_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableExportedAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportedAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ExportedAuthorization, some of required attributes are not set " + attributes;
        }

        private ByteBuf bytes_build() {
            return Objects.requireNonNull(this.bytes_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableExportedAuthorization.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ExportedAuthorization, attribute initializers form cycle " + attributes;
        }
    }
}

