/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.LoggedOut;

public final class ImmutableLoggedOut
implements LoggedOut {
    private final int identifier;
    private final int flags;
    private final ByteBuf futureAuthToken;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableLoggedOut INSTANCE = ImmutableLoggedOut.validate(new ImmutableLoggedOut());

    private ImmutableLoggedOut() {
        this.futureAuthToken = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableLoggedOut(Builder builder) {
        this.futureAuthToken = builder.futureAuthToken_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableLoggedOut(int identifier, int flags, ByteBuf futureAuthToken) {
        this.identifier = identifier;
        this.flags = flags;
        this.futureAuthToken = futureAuthToken;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return LoggedOut.super.identifier();
    }

    private int flagsInitialize() {
        return LoggedOut.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public Optional<ByteBuf> futureAuthToken() {
        return Optional.ofNullable(this.futureAuthToken).map(ByteBuf::duplicate);
    }

    public final ImmutableLoggedOut withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableLoggedOut.validate(new ImmutableLoggedOut(value, this.flags, this.futureAuthToken));
    }

    public final ImmutableLoggedOut withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableLoggedOut.validate(new ImmutableLoggedOut(this.identifier, value, this.futureAuthToken));
    }

    public ImmutableLoggedOut withFutureAuthToken(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.futureAuthToken == newValue) {
            return this;
        }
        return ImmutableLoggedOut.validate(new ImmutableLoggedOut(this.identifier, this.flags, newValue));
    }

    public ImmutableLoggedOut withFutureAuthToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.futureAuthToken == newValue) {
            return this;
        }
        return ImmutableLoggedOut.validate(new ImmutableLoggedOut(this.identifier, this.flags, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoggedOut && this.equalTo(0, (ImmutableLoggedOut)another);
    }

    private boolean equalTo(int synthetic, ImmutableLoggedOut another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.futureAuthToken().equals(another.futureAuthToken());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.futureAuthToken().hashCode();
        return h;
    }

    public String toString() {
        return "LoggedOut{identifier=" + this.identifier + ", flags=" + this.flags + ", futureAuthToken=" + this.futureAuthToken().map(ByteBufUtil::hexDump).toString() + "}";
    }

    public static ImmutableLoggedOut of() {
        return INSTANCE;
    }

    private static ImmutableLoggedOut validate(ImmutableLoggedOut instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableLoggedOut copyOf(LoggedOut instance) {
        if (instance instanceof ImmutableLoggedOut) {
            return (ImmutableLoggedOut)instance;
        }
        return ImmutableLoggedOut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private ByteBuf futureAuthToken_value = null;
        private int identifier;
        private int flags;

        private Builder() {
        }

        public final Builder from(LoggedOut instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LoggedOut instance;
            long bits = 0L;
            if (object instanceof LoggedOut) {
                instance = (LoggedOut)object;
                this.flags(instance.flags());
                this.futureAuthToken(instance.futureAuthToken());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public Builder futureAuthToken(@Nullable ByteBuf value) {
            this.futureAuthToken_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder futureAuthToken(Optional<ByteBuf> value) {
            this.futureAuthToken_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public ImmutableLoggedOut build() {
            return ImmutableLoggedOut.validate(new ImmutableLoggedOut(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private ByteBuf futureAuthToken_build() {
            return this.futureAuthToken_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableLoggedOut.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableLoggedOut.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build LoggedOut, attribute initializers form cycle " + attributes;
        }
    }
}

