/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.LoginToken;
import telegram4j.tl.auth.LoginTokenMigrateTo;

public final class ImmutableLoginTokenMigrateTo
implements LoginTokenMigrateTo {
    private final int identifier;
    private final int dcId;
    private final ByteBuf token;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLoginTokenMigrateTo(int dcId) {
        this.dcId = dcId;
        this.token = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableLoginTokenMigrateTo(Builder builder) {
        this.dcId = builder.dcId;
        this.token = builder.token_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableLoginTokenMigrateTo(int identifier, int dcId, ByteBuf token) {
        this.identifier = identifier;
        this.dcId = dcId;
        this.token = token;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return LoginTokenMigrateTo.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public ByteBuf token() {
        return this.token.duplicate();
    }

    public final ImmutableLoginTokenMigrateTo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLoginTokenMigrateTo(value, this.dcId, this.token);
    }

    public final ImmutableLoginTokenMigrateTo withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableLoginTokenMigrateTo(this.identifier, value, this.token);
    }

    public ImmutableLoginTokenMigrateTo withToken(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.token == newValue) {
            return this;
        }
        return new ImmutableLoginTokenMigrateTo(this.identifier, this.dcId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoginTokenMigrateTo && this.equalTo(0, (ImmutableLoginTokenMigrateTo)another);
    }

    private boolean equalTo(int synthetic, ImmutableLoginTokenMigrateTo another) {
        return this.identifier == another.identifier && this.dcId == another.dcId && this.token().equals((Object)another.token());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dcId;
        h += (h << 5) + this.token().hashCode();
        return h;
    }

    public String toString() {
        return "LoginTokenMigrateTo{identifier=" + this.identifier + ", dcId=" + this.dcId + ", token=" + ByteBufUtil.hexDump((ByteBuf)this.token) + "}";
    }

    public static ImmutableLoginTokenMigrateTo of(int dcId) {
        return new ImmutableLoginTokenMigrateTo(dcId);
    }

    public static ImmutableLoginTokenMigrateTo copyOf(LoginTokenMigrateTo instance) {
        if (instance instanceof ImmutableLoginTokenMigrateTo) {
            return (ImmutableLoginTokenMigrateTo)instance;
        }
        return ImmutableLoginTokenMigrateTo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DC_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf token_value = null;
        private int identifier;
        private int dcId;

        private Builder() {
        }

        public final Builder from(LoginToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LoginTokenMigrateTo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LoginToken instance;
            long bits = 0L;
            if (object instanceof LoginToken) {
                instance = (LoginToken)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof LoginTokenMigrateTo) {
                instance = (LoginTokenMigrateTo)object;
                this.dcId(instance.dcId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.token(instance.token());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder token(ByteBuf value) {
            this.token_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableLoginTokenMigrateTo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLoginTokenMigrateTo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dcId");
            }
            return "Cannot build LoginTokenMigrateTo, some of required attributes are not set " + attributes;
        }

        private ByteBuf token_build() {
            return Objects.requireNonNull(this.token_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableLoginTokenMigrateTo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build LoginTokenMigrateTo, attribute initializers form cycle " + attributes;
        }
    }
}

