/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.Authorization;
import telegram4j.tl.auth.LoginToken;
import telegram4j.tl.auth.LoginTokenSuccess;

public final class ImmutableLoginTokenSuccess
implements LoginTokenSuccess {
    private final int identifier;
    private final Authorization authorization;

    private ImmutableLoginTokenSuccess(Authorization authorization) {
        this.authorization = Objects.requireNonNull(authorization, "authorization");
        this.identifier = LoginTokenSuccess.super.identifier();
    }

    private ImmutableLoginTokenSuccess(Builder builder) {
        this.authorization = builder.authorization;
        this.identifier = builder.identifierIsSet() ? builder.identifier : LoginTokenSuccess.super.identifier();
    }

    private ImmutableLoginTokenSuccess(int identifier, Authorization authorization) {
        this.identifier = identifier;
        this.authorization = authorization;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Authorization authorization() {
        return this.authorization;
    }

    public final ImmutableLoginTokenSuccess withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLoginTokenSuccess(value, this.authorization);
    }

    public final ImmutableLoginTokenSuccess withAuthorization(Authorization value) {
        if (this.authorization == value) {
            return this;
        }
        Authorization newValue = Objects.requireNonNull(value, "authorization");
        return new ImmutableLoginTokenSuccess(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoginTokenSuccess && this.equalTo(0, (ImmutableLoginTokenSuccess)another);
    }

    private boolean equalTo(int synthetic, ImmutableLoginTokenSuccess another) {
        return this.identifier == another.identifier && this.authorization.equals(another.authorization);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.authorization.hashCode();
        return h;
    }

    public String toString() {
        return "LoginTokenSuccess{identifier=" + this.identifier + ", authorization=" + this.authorization + "}";
    }

    public static ImmutableLoginTokenSuccess of(Authorization authorization) {
        return new ImmutableLoginTokenSuccess(authorization);
    }

    public static ImmutableLoginTokenSuccess copyOf(LoginTokenSuccess instance) {
        if (instance instanceof ImmutableLoginTokenSuccess) {
            return (ImmutableLoginTokenSuccess)instance;
        }
        return ImmutableLoginTokenSuccess.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_AUTHORIZATION = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Authorization authorization;

        private Builder() {
        }

        public final Builder from(LoginTokenSuccess instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LoginToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LoginToken instance;
            long bits = 0L;
            if (object instanceof LoginTokenSuccess) {
                instance = (LoginTokenSuccess)object;
                this.authorization(instance.authorization());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof LoginToken) {
                instance = (LoginToken)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder authorization(Authorization authorization) {
            this.authorization = Objects.requireNonNull(authorization, "authorization");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableLoginTokenSuccess build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLoginTokenSuccess(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authorization");
            }
            return "Cannot build LoginTokenSuccess, some of required attributes are not set " + attributes;
        }
    }
}

