/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.PasswordRecovery;

public final class ImmutablePasswordRecovery
implements PasswordRecovery {
    private final int identifier;
    private final String emailPattern;

    private ImmutablePasswordRecovery(String emailPattern) {
        this.emailPattern = Objects.requireNonNull(emailPattern, "emailPattern");
        this.identifier = PasswordRecovery.super.identifier();
    }

    private ImmutablePasswordRecovery(Builder builder) {
        this.emailPattern = builder.emailPattern;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PasswordRecovery.super.identifier();
    }

    private ImmutablePasswordRecovery(int identifier, String emailPattern) {
        this.identifier = identifier;
        this.emailPattern = emailPattern;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emailPattern() {
        return this.emailPattern;
    }

    public final ImmutablePasswordRecovery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePasswordRecovery(value, this.emailPattern);
    }

    public final ImmutablePasswordRecovery withEmailPattern(String value) {
        String newValue = Objects.requireNonNull(value, "emailPattern");
        if (this.emailPattern.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordRecovery(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordRecovery && this.equalTo(0, (ImmutablePasswordRecovery)another);
    }

    private boolean equalTo(int synthetic, ImmutablePasswordRecovery another) {
        return this.identifier == another.identifier && this.emailPattern.equals(another.emailPattern);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emailPattern.hashCode();
        return h;
    }

    public String toString() {
        return "PasswordRecovery{identifier=" + this.identifier + ", emailPattern=" + this.emailPattern + "}";
    }

    public static ImmutablePasswordRecovery of(String emailPattern) {
        return new ImmutablePasswordRecovery(emailPattern);
    }

    public static ImmutablePasswordRecovery copyOf(PasswordRecovery instance) {
        if (instance instanceof ImmutablePasswordRecovery) {
            return (ImmutablePasswordRecovery)instance;
        }
        return ImmutablePasswordRecovery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMAIL_PATTERN = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String emailPattern;

        private Builder() {
        }

        public final Builder from(PasswordRecovery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PasswordRecovery instance;
            long bits = 0L;
            if (object instanceof PasswordRecovery) {
                instance = (PasswordRecovery)object;
                this.emailPattern(instance.emailPattern());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emailPattern(String emailPattern) {
            this.emailPattern = Objects.requireNonNull(emailPattern, "emailPattern");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePasswordRecovery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePasswordRecovery(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emailPattern");
            }
            return "Cannot build PasswordRecovery, some of required attributes are not set " + attributes;
        }
    }
}

