/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.CodeType;
import telegram4j.tl.auth.SentCode;
import telegram4j.tl.auth.SentCodeType;

public final class ImmutableSentCode
implements SentCode {
    private final int identifier;
    private final int flags;
    private final SentCodeType type;
    private final String phoneCodeHash;
    @Nullable
    private final CodeType nextType;
    @Nullable
    private final Integer timeout;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSentCode(SentCodeType type, String phoneCodeHash) {
        this.type = Objects.requireNonNull(type, "type");
        this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
        this.nextType = null;
        this.timeout = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSentCode(Builder builder) {
        this.type = builder.type;
        this.phoneCodeHash = builder.phoneCodeHash;
        this.nextType = builder.nextType;
        this.timeout = builder.timeout;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSentCode(int identifier, int flags, SentCodeType type, String phoneCodeHash, @Nullable CodeType nextType, @Nullable Integer timeout) {
        this.identifier = identifier;
        this.flags = flags;
        this.type = type;
        this.phoneCodeHash = phoneCodeHash;
        this.nextType = nextType;
        this.timeout = timeout;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SentCode.super.identifier();
    }

    private int flagsInitialize() {
        return SentCode.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public SentCodeType type() {
        return this.type;
    }

    @Override
    public String phoneCodeHash() {
        return this.phoneCodeHash;
    }

    @Override
    @Nullable
    public CodeType nextType() {
        return this.nextType;
    }

    @Override
    @Nullable
    public Integer timeout() {
        return this.timeout;
    }

    public final ImmutableSentCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentCode(value, this.flags, this.type, this.phoneCodeHash, this.nextType, this.timeout);
    }

    public final ImmutableSentCode withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSentCode(this.identifier, value, this.type, this.phoneCodeHash, this.nextType, this.timeout);
    }

    public final ImmutableSentCode withType(SentCodeType value) {
        if (this.type == value) {
            return this;
        }
        SentCodeType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableSentCode(this.identifier, this.flags, newValue, this.phoneCodeHash, this.nextType, this.timeout);
    }

    public final ImmutableSentCode withPhoneCodeHash(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCodeHash");
        if (this.phoneCodeHash.equals(newValue)) {
            return this;
        }
        return new ImmutableSentCode(this.identifier, this.flags, this.type, newValue, this.nextType, this.timeout);
    }

    public final ImmutableSentCode withNextType(@Nullable CodeType value) {
        if (this.nextType == value) {
            return this;
        }
        return new ImmutableSentCode(this.identifier, this.flags, this.type, this.phoneCodeHash, value, this.timeout);
    }

    public final ImmutableSentCode withTimeout(@Nullable Integer value) {
        if (Objects.equals(this.timeout, value)) {
            return this;
        }
        return new ImmutableSentCode(this.identifier, this.flags, this.type, this.phoneCodeHash, this.nextType, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentCode && this.equalTo(0, (ImmutableSentCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentCode another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.type.equals(another.type) && this.phoneCodeHash.equals(another.phoneCodeHash) && Objects.equals((Object)this.nextType, (Object)another.nextType) && Objects.equals(this.timeout, another.timeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.phoneCodeHash.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.nextType);
        h += (h << 5) + Objects.hashCode(this.timeout);
        return h;
    }

    public String toString() {
        return "SentCode{identifier=" + this.identifier + ", flags=" + this.flags + ", type=" + this.type + ", phoneCodeHash=" + this.phoneCodeHash + ", nextType=" + this.nextType + ", timeout=" + this.timeout + "}";
    }

    public static ImmutableSentCode of(SentCodeType type, String phoneCodeHash) {
        return new ImmutableSentCode(type, phoneCodeHash);
    }

    public static ImmutableSentCode copyOf(SentCode instance) {
        if (instance instanceof ImmutableSentCode) {
            return (ImmutableSentCode)instance;
        }
        return ImmutableSentCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_PHONE_CODE_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private SentCodeType type;
        private String phoneCodeHash;
        private CodeType nextType;
        private Integer timeout;

        private Builder() {
        }

        public final Builder from(SentCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SentCode instance;
            long bits = 0L;
            if (object instanceof SentCode) {
                CodeType nextTypeValue;
                instance = (SentCode)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((nextTypeValue = instance.nextType()) != null) {
                    this.nextType(nextTypeValue);
                }
                this.type(instance.type());
                Integer timeoutValue = instance.timeout();
                if (timeoutValue != null) {
                    this.timeout(timeoutValue);
                }
                this.phoneCodeHash(instance.phoneCodeHash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder type(SentCodeType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phoneCodeHash(String phoneCodeHash) {
            this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder nextType(@Nullable CodeType nextType) {
            this.nextType = nextType;
            return this;
        }

        public final Builder timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ImmutableSentCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phoneCodeHash");
            }
            return "Cannot build SentCode, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSentCode.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSentCode.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build SentCode, attribute initializers form cycle " + attributes;
        }
    }
}

