/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.SentCodeType;
import telegram4j.tl.auth.SentCodeTypeApp;

public final class ImmutableSentCodeTypeApp
implements SentCodeTypeApp {
    private final int identifier;
    private final int length;

    private ImmutableSentCodeTypeApp(int length) {
        this.length = length;
        this.identifier = SentCodeTypeApp.super.identifier();
    }

    private ImmutableSentCodeTypeApp(Builder builder) {
        this.length = builder.length;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SentCodeTypeApp.super.identifier();
    }

    private ImmutableSentCodeTypeApp(int identifier, int length) {
        this.identifier = identifier;
        this.length = length;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int length() {
        return this.length;
    }

    public final ImmutableSentCodeTypeApp withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentCodeTypeApp(value, this.length);
    }

    public final ImmutableSentCodeTypeApp withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableSentCodeTypeApp(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentCodeTypeApp && this.equalTo(0, (ImmutableSentCodeTypeApp)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentCodeTypeApp another) {
        return this.identifier == another.identifier && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return "SentCodeTypeApp{identifier=" + this.identifier + ", length=" + this.length + "}";
    }

    public static ImmutableSentCodeTypeApp of(int length) {
        return new ImmutableSentCodeTypeApp(length);
    }

    public static ImmutableSentCodeTypeApp copyOf(SentCodeTypeApp instance) {
        if (instance instanceof ImmutableSentCodeTypeApp) {
            return (ImmutableSentCodeTypeApp)instance;
        }
        return ImmutableSentCodeTypeApp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LENGTH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int length;

        private Builder() {
        }

        public final Builder from(SentCodeTypeApp instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SentCodeType instance;
            long bits = 0L;
            if (object instanceof SentCodeTypeApp) {
                instance = (SentCodeTypeApp)object;
                this.length(instance.length());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SentCodeType) {
                instance = (SentCodeType)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSentCodeTypeApp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentCodeTypeApp(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build SentCodeTypeApp, some of required attributes are not set " + attributes;
        }
    }
}

