/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.SentCodeType;
import telegram4j.tl.auth.SentCodeTypeCall;

public final class ImmutableSentCodeTypeCall
implements SentCodeTypeCall {
    private final int identifier;
    private final int length;

    private ImmutableSentCodeTypeCall(int length) {
        this.length = length;
        this.identifier = SentCodeTypeCall.super.identifier();
    }

    private ImmutableSentCodeTypeCall(Builder builder) {
        this.length = builder.length;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SentCodeTypeCall.super.identifier();
    }

    private ImmutableSentCodeTypeCall(int identifier, int length) {
        this.identifier = identifier;
        this.length = length;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int length() {
        return this.length;
    }

    public final ImmutableSentCodeTypeCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentCodeTypeCall(value, this.length);
    }

    public final ImmutableSentCodeTypeCall withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableSentCodeTypeCall(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentCodeTypeCall && this.equalTo(0, (ImmutableSentCodeTypeCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentCodeTypeCall another) {
        return this.identifier == another.identifier && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return "SentCodeTypeCall{identifier=" + this.identifier + ", length=" + this.length + "}";
    }

    public static ImmutableSentCodeTypeCall of(int length) {
        return new ImmutableSentCodeTypeCall(length);
    }

    public static ImmutableSentCodeTypeCall copyOf(SentCodeTypeCall instance) {
        if (instance instanceof ImmutableSentCodeTypeCall) {
            return (ImmutableSentCodeTypeCall)instance;
        }
        return ImmutableSentCodeTypeCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LENGTH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int length;

        private Builder() {
        }

        public final Builder from(SentCodeTypeCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SentCodeType instance;
            long bits = 0L;
            if (object instanceof SentCodeTypeCall) {
                instance = (SentCodeTypeCall)object;
                this.length(instance.length());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SentCodeType) {
                instance = (SentCodeType)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSentCodeTypeCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentCodeTypeCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build SentCodeTypeCall, some of required attributes are not set " + attributes;
        }
    }
}

