/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.SentCodeType;
import telegram4j.tl.auth.SentCodeTypeFlashCall;

public final class ImmutableSentCodeTypeFlashCall
implements SentCodeTypeFlashCall {
    private final int identifier;
    private final String pattern;

    private ImmutableSentCodeTypeFlashCall(String pattern) {
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.identifier = SentCodeTypeFlashCall.super.identifier();
    }

    private ImmutableSentCodeTypeFlashCall(Builder builder) {
        this.pattern = builder.pattern;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SentCodeTypeFlashCall.super.identifier();
    }

    private ImmutableSentCodeTypeFlashCall(int identifier, String pattern) {
        this.identifier = identifier;
        this.pattern = pattern;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    public final ImmutableSentCodeTypeFlashCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentCodeTypeFlashCall(value, this.pattern);
    }

    public final ImmutableSentCodeTypeFlashCall withPattern(String value) {
        String newValue = Objects.requireNonNull(value, "pattern");
        if (this.pattern.equals(newValue)) {
            return this;
        }
        return new ImmutableSentCodeTypeFlashCall(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentCodeTypeFlashCall && this.equalTo(0, (ImmutableSentCodeTypeFlashCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentCodeTypeFlashCall another) {
        return this.identifier == another.identifier && this.pattern.equals(another.pattern);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pattern.hashCode();
        return h;
    }

    public String toString() {
        return "SentCodeTypeFlashCall{identifier=" + this.identifier + ", pattern=" + this.pattern + "}";
    }

    public static ImmutableSentCodeTypeFlashCall of(String pattern) {
        return new ImmutableSentCodeTypeFlashCall(pattern);
    }

    public static ImmutableSentCodeTypeFlashCall copyOf(SentCodeTypeFlashCall instance) {
        if (instance instanceof ImmutableSentCodeTypeFlashCall) {
            return (ImmutableSentCodeTypeFlashCall)instance;
        }
        return ImmutableSentCodeTypeFlashCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PATTERN = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String pattern;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeTypeFlashCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SentCodeTypeFlashCall) {
                instance = (SentCodeTypeFlashCall)object;
                this.pattern(instance.pattern());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SentCodeType) {
                instance = (SentCodeType)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pattern(String pattern) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSentCodeTypeFlashCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentCodeTypeFlashCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pattern");
            }
            return "Cannot build SentCodeTypeFlashCall, some of required attributes are not set " + attributes;
        }
    }
}

