/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.SentCodeType;
import telegram4j.tl.auth.SentCodeTypeMissedCall;

public final class ImmutableSentCodeTypeMissedCall
implements SentCodeTypeMissedCall {
    private final int identifier;
    private final String prefix;
    private final int length;

    private ImmutableSentCodeTypeMissedCall(String prefix, int length) {
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.length = length;
        this.identifier = SentCodeTypeMissedCall.super.identifier();
    }

    private ImmutableSentCodeTypeMissedCall(Builder builder) {
        this.prefix = builder.prefix;
        this.length = builder.length;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SentCodeTypeMissedCall.super.identifier();
    }

    private ImmutableSentCodeTypeMissedCall(int identifier, String prefix, int length) {
        this.identifier = identifier;
        this.prefix = prefix;
        this.length = length;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public int length() {
        return this.length;
    }

    public final ImmutableSentCodeTypeMissedCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentCodeTypeMissedCall(value, this.prefix, this.length);
    }

    public final ImmutableSentCodeTypeMissedCall withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return new ImmutableSentCodeTypeMissedCall(this.identifier, newValue, this.length);
    }

    public final ImmutableSentCodeTypeMissedCall withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableSentCodeTypeMissedCall(this.identifier, this.prefix, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentCodeTypeMissedCall && this.equalTo(0, (ImmutableSentCodeTypeMissedCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentCodeTypeMissedCall another) {
        return this.identifier == another.identifier && this.prefix.equals(another.prefix) && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.prefix.hashCode();
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return "SentCodeTypeMissedCall{identifier=" + this.identifier + ", prefix=" + this.prefix + ", length=" + this.length + "}";
    }

    public static ImmutableSentCodeTypeMissedCall of(String prefix, int length) {
        return new ImmutableSentCodeTypeMissedCall(prefix, length);
    }

    public static ImmutableSentCodeTypeMissedCall copyOf(SentCodeTypeMissedCall instance) {
        if (instance instanceof ImmutableSentCodeTypeMissedCall) {
            return (ImmutableSentCodeTypeMissedCall)instance;
        }
        return ImmutableSentCodeTypeMissedCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREFIX = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String prefix;
        private int length;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeTypeMissedCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SentCodeTypeMissedCall) {
                instance = (SentCodeTypeMissedCall)object;
                this.length(instance.length());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.prefix(instance.prefix());
            }
            if (object instanceof SentCodeType) {
                instance = (SentCodeType)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSentCodeTypeMissedCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentCodeTypeMissedCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prefix");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build SentCodeTypeMissedCall, some of required attributes are not set " + attributes;
        }
    }
}

