/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.auth.SentCodeType;
import telegram4j.tl.auth.SentCodeTypeSms;

public final class ImmutableSentCodeTypeSms
implements SentCodeTypeSms {
    private final int identifier;
    private final int length;

    private ImmutableSentCodeTypeSms(int length) {
        this.length = length;
        this.identifier = SentCodeTypeSms.super.identifier();
    }

    private ImmutableSentCodeTypeSms(Builder builder) {
        this.length = builder.length;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SentCodeTypeSms.super.identifier();
    }

    private ImmutableSentCodeTypeSms(int identifier, int length) {
        this.identifier = identifier;
        this.length = length;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int length() {
        return this.length;
    }

    public final ImmutableSentCodeTypeSms withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentCodeTypeSms(value, this.length);
    }

    public final ImmutableSentCodeTypeSms withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableSentCodeTypeSms(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentCodeTypeSms && this.equalTo(0, (ImmutableSentCodeTypeSms)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentCodeTypeSms another) {
        return this.identifier == another.identifier && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return "SentCodeTypeSms{identifier=" + this.identifier + ", length=" + this.length + "}";
    }

    public static ImmutableSentCodeTypeSms of(int length) {
        return new ImmutableSentCodeTypeSms(length);
    }

    public static ImmutableSentCodeTypeSms copyOf(SentCodeTypeSms instance) {
        if (instance instanceof ImmutableSentCodeTypeSms) {
            return (ImmutableSentCodeTypeSms)instance;
        }
        return ImmutableSentCodeTypeSms.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LENGTH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int length;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeTypeSms instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentCodeType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SentCodeTypeSms) {
                instance = (SentCodeTypeSms)object;
                this.length(instance.length());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SentCodeType) {
                instance = (SentCodeType)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSentCodeTypeSms build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentCodeTypeSms(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build SentCodeTypeSms, some of required attributes are not set " + attributes;
        }
    }
}

