/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.channels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ChannelAdminLogEvent;
import telegram4j.tl.Chat;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.channels.AdminLogResults;

public final class ImmutableAdminLogResults
implements AdminLogResults {
    private final int identifier;
    private final List<ChannelAdminLogEvent> events;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableAdminLogResults(Builder builder) {
        this.events = ImmutableAdminLogResults.createUnmodifiableList(true, builder.events);
        this.chats = ImmutableAdminLogResults.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableAdminLogResults.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : AdminLogResults.super.identifier();
    }

    private ImmutableAdminLogResults(int identifier, List<ChannelAdminLogEvent> events, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.events = events;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<ChannelAdminLogEvent> events() {
        return this.events;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableAdminLogResults withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAdminLogResults(value, this.events, this.chats, this.users);
    }

    public final ImmutableAdminLogResults withEvents(ChannelAdminLogEvent ... elements) {
        List<ChannelAdminLogEvent> newValue = ImmutableAdminLogResults.createUnmodifiableList(false, ImmutableAdminLogResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAdminLogResults(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableAdminLogResults withEvents(Iterable<? extends ChannelAdminLogEvent> elements) {
        if (this.events == elements) {
            return this;
        }
        List<ChannelAdminLogEvent> newValue = ImmutableAdminLogResults.createUnmodifiableList(false, ImmutableAdminLogResults.createSafeList(elements, true, false));
        return new ImmutableAdminLogResults(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableAdminLogResults withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableAdminLogResults.createUnmodifiableList(false, ImmutableAdminLogResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAdminLogResults(this.identifier, this.events, newValue, this.users);
    }

    public final ImmutableAdminLogResults withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableAdminLogResults.createUnmodifiableList(false, ImmutableAdminLogResults.createSafeList(elements, true, false));
        return new ImmutableAdminLogResults(this.identifier, this.events, newValue, this.users);
    }

    public final ImmutableAdminLogResults withUsers(User ... elements) {
        List<User> newValue = ImmutableAdminLogResults.createUnmodifiableList(false, ImmutableAdminLogResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAdminLogResults(this.identifier, this.events, this.chats, newValue);
    }

    public final ImmutableAdminLogResults withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableAdminLogResults.createUnmodifiableList(false, ImmutableAdminLogResults.createSafeList(elements, true, false));
        return new ImmutableAdminLogResults(this.identifier, this.events, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdminLogResults && this.equalTo(0, (ImmutableAdminLogResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableAdminLogResults another) {
        return this.identifier == another.identifier && this.events.equals(another.events) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.events.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "AdminLogResults{identifier=" + this.identifier + ", events=" + this.events + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableAdminLogResults copyOf(AdminLogResults instance) {
        if (instance instanceof ImmutableAdminLogResults) {
            return (ImmutableAdminLogResults)instance;
        }
        return ImmutableAdminLogResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<ChannelAdminLogEvent> events = new ArrayList<ChannelAdminLogEvent>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(AdminLogResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AdminLogResults instance;
            long bits = 0L;
            if (object instanceof AdminLogResults) {
                instance = (AdminLogResults)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllEvents(instance.events());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addEvent(ChannelAdminLogEvent element) {
            this.events.add(Objects.requireNonNull(element, "events element"));
            return this;
        }

        public final Builder addEvents(ChannelAdminLogEvent ... elements) {
            for (ChannelAdminLogEvent element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        public final Builder events(Iterable<? extends ChannelAdminLogEvent> elements) {
            this.events.clear();
            return this.addAllEvents(elements);
        }

        public final Builder addAllEvents(Iterable<? extends ChannelAdminLogEvent> elements) {
            for (ChannelAdminLogEvent channelAdminLogEvent : elements) {
                this.events.add(Objects.requireNonNull(channelAdminLogEvent, "events element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableAdminLogResults build() {
            return new ImmutableAdminLogResults(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

