/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.channels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.Chat;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.channels.BaseChannelParticipants;
import telegram4j.tl.channels.ChannelParticipants;

public final class ImmutableBaseChannelParticipants
implements BaseChannelParticipants {
    private final int identifier;
    private final int count;
    private final List<ChannelParticipant> participants;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableBaseChannelParticipants(int count) {
        this.count = count;
        this.participants = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = BaseChannelParticipants.super.identifier();
    }

    private ImmutableBaseChannelParticipants(Builder builder) {
        this.count = builder.count;
        this.participants = ImmutableBaseChannelParticipants.createUnmodifiableList(true, builder.participants);
        this.chats = ImmutableBaseChannelParticipants.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBaseChannelParticipants.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseChannelParticipants.super.identifier();
    }

    private ImmutableBaseChannelParticipants(int identifier, int count, List<ChannelParticipant> participants, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.count = count;
        this.participants = participants;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<ChannelParticipant> participants() {
        return this.participants;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseChannelParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChannelParticipants(value, this.count, this.participants, this.chats, this.users);
    }

    public final ImmutableBaseChannelParticipants withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableBaseChannelParticipants(this.identifier, value, this.participants, this.chats, this.users);
    }

    public final ImmutableBaseChannelParticipants withParticipants(ChannelParticipant ... elements) {
        List<ChannelParticipant> newValue = ImmutableBaseChannelParticipants.createUnmodifiableList(false, ImmutableBaseChannelParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelParticipants(this.identifier, this.count, newValue, this.chats, this.users);
    }

    public final ImmutableBaseChannelParticipants withParticipants(Iterable<? extends ChannelParticipant> elements) {
        if (this.participants == elements) {
            return this;
        }
        List<ChannelParticipant> newValue = ImmutableBaseChannelParticipants.createUnmodifiableList(false, ImmutableBaseChannelParticipants.createSafeList(elements, true, false));
        return new ImmutableBaseChannelParticipants(this.identifier, this.count, newValue, this.chats, this.users);
    }

    public final ImmutableBaseChannelParticipants withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseChannelParticipants.createUnmodifiableList(false, ImmutableBaseChannelParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelParticipants(this.identifier, this.count, this.participants, newValue, this.users);
    }

    public final ImmutableBaseChannelParticipants withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseChannelParticipants.createUnmodifiableList(false, ImmutableBaseChannelParticipants.createSafeList(elements, true, false));
        return new ImmutableBaseChannelParticipants(this.identifier, this.count, this.participants, newValue, this.users);
    }

    public final ImmutableBaseChannelParticipants withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseChannelParticipants.createUnmodifiableList(false, ImmutableBaseChannelParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChannelParticipants(this.identifier, this.count, this.participants, this.chats, newValue);
    }

    public final ImmutableBaseChannelParticipants withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseChannelParticipants.createUnmodifiableList(false, ImmutableBaseChannelParticipants.createSafeList(elements, true, false));
        return new ImmutableBaseChannelParticipants(this.identifier, this.count, this.participants, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChannelParticipants && this.equalTo(0, (ImmutableBaseChannelParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChannelParticipants another) {
        return this.identifier == another.identifier && this.count == another.count && this.participants.equals(another.participants) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.participants.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseChannelParticipants{identifier=" + this.identifier + ", count=" + this.count + ", participants=" + this.participants + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableBaseChannelParticipants of(int count) {
        return new ImmutableBaseChannelParticipants(count);
    }

    public static ImmutableBaseChannelParticipants copyOf(BaseChannelParticipants instance) {
        if (instance instanceof ImmutableBaseChannelParticipants) {
            return (ImmutableBaseChannelParticipants)instance;
        }
        return ImmutableBaseChannelParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<ChannelParticipant> participants = new ArrayList<ChannelParticipant>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseChannelParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelParticipants) {
                instance = (ChannelParticipants)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseChannelParticipants) {
                instance = (BaseChannelParticipants)object;
                this.count(instance.count());
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
                this.addAllParticipants(instance.participants());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParticipant(ChannelParticipant element) {
            this.participants.add(Objects.requireNonNull(element, "participants element"));
            return this;
        }

        public final Builder addParticipants(ChannelParticipant ... elements) {
            for (ChannelParticipant element : elements) {
                this.participants.add(Objects.requireNonNull(element, "participants element"));
            }
            return this;
        }

        public final Builder participants(Iterable<? extends ChannelParticipant> elements) {
            this.participants.clear();
            return this.addAllParticipants(elements);
        }

        public final Builder addAllParticipants(Iterable<? extends ChannelParticipant> elements) {
            for (ChannelParticipant channelParticipant : elements) {
                this.participants.add(Objects.requireNonNull(channelParticipant, "participants element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseChannelParticipants build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseChannelParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build BaseChannelParticipants, some of required attributes are not set " + attributes;
        }
    }
}

