/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.channels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.Chat;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipant
implements telegram4j.tl.channels.ChannelParticipant {
    private final int identifier;
    private final ChannelParticipant participant;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableChannelParticipant(ChannelParticipant participant) {
        this.participant = Objects.requireNonNull(participant, "participant");
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = telegram4j.tl.channels.ChannelParticipant.super.identifier();
    }

    private ImmutableChannelParticipant(Builder builder) {
        this.participant = builder.participant;
        this.chats = ImmutableChannelParticipant.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableChannelParticipant.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : telegram4j.tl.channels.ChannelParticipant.super.identifier();
    }

    private ImmutableChannelParticipant(int identifier, ChannelParticipant participant, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.participant = participant;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public ChannelParticipant participant() {
        return this.participant;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableChannelParticipant withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelParticipant(value, this.participant, this.chats, this.users);
    }

    public final ImmutableChannelParticipant withParticipant(ChannelParticipant value) {
        if (this.participant == value) {
            return this;
        }
        ChannelParticipant newValue = Objects.requireNonNull(value, "participant");
        return new ImmutableChannelParticipant(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableChannelParticipant withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableChannelParticipant.createUnmodifiableList(false, ImmutableChannelParticipant.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelParticipant(this.identifier, this.participant, newValue, this.users);
    }

    public final ImmutableChannelParticipant withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableChannelParticipant.createUnmodifiableList(false, ImmutableChannelParticipant.createSafeList(elements, true, false));
        return new ImmutableChannelParticipant(this.identifier, this.participant, newValue, this.users);
    }

    public final ImmutableChannelParticipant withUsers(User ... elements) {
        List<User> newValue = ImmutableChannelParticipant.createUnmodifiableList(false, ImmutableChannelParticipant.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelParticipant(this.identifier, this.participant, this.chats, newValue);
    }

    public final ImmutableChannelParticipant withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableChannelParticipant.createUnmodifiableList(false, ImmutableChannelParticipant.createSafeList(elements, true, false));
        return new ImmutableChannelParticipant(this.identifier, this.participant, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipant && this.equalTo(0, (ImmutableChannelParticipant)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipant another) {
        return this.identifier == another.identifier && this.participant.equals(another.participant) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.participant.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelParticipant{identifier=" + this.identifier + ", participant=" + this.participant + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableChannelParticipant of(ChannelParticipant participant) {
        return new ImmutableChannelParticipant(participant);
    }

    public static ImmutableChannelParticipant copyOf(telegram4j.tl.channels.ChannelParticipant instance) {
        if (instance instanceof ImmutableChannelParticipant) {
            return (ImmutableChannelParticipant)instance;
        }
        return ImmutableChannelParticipant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PARTICIPANT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private ChannelParticipant participant;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(telegram4j.tl.channels.ChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof telegram4j.tl.channels.ChannelParticipant) {
                instance = (telegram4j.tl.channels.ChannelParticipant)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.participant(instance.participant());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder participant(ChannelParticipant participant) {
            this.participant = Objects.requireNonNull(participant, "participant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableChannelParticipant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelParticipant(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("participant");
            }
            return "Cannot build ChannelParticipant, some of required attributes are not set " + attributes;
        }
    }
}

