/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.PeerBlocked;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.contacts.BaseBlocked;
import telegram4j.tl.contacts.Blocked;

public final class ImmutableBaseBlocked
implements BaseBlocked {
    private final int identifier;
    private final List<PeerBlocked> blocked;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableBaseBlocked(Builder builder) {
        this.blocked = ImmutableBaseBlocked.createUnmodifiableList(true, builder.blocked);
        this.chats = ImmutableBaseBlocked.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBaseBlocked.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseBlocked.super.identifier();
    }

    private ImmutableBaseBlocked(int identifier, List<PeerBlocked> blocked, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.blocked = blocked;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<PeerBlocked> blocked() {
        return this.blocked;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseBlocked withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseBlocked(value, this.blocked, this.chats, this.users);
    }

    public final ImmutableBaseBlocked withBlocked(PeerBlocked ... elements) {
        List<PeerBlocked> newValue = ImmutableBaseBlocked.createUnmodifiableList(false, ImmutableBaseBlocked.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseBlocked(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableBaseBlocked withBlocked(Iterable<? extends PeerBlocked> elements) {
        if (this.blocked == elements) {
            return this;
        }
        List<PeerBlocked> newValue = ImmutableBaseBlocked.createUnmodifiableList(false, ImmutableBaseBlocked.createSafeList(elements, true, false));
        return new ImmutableBaseBlocked(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableBaseBlocked withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseBlocked.createUnmodifiableList(false, ImmutableBaseBlocked.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseBlocked(this.identifier, this.blocked, newValue, this.users);
    }

    public final ImmutableBaseBlocked withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseBlocked.createUnmodifiableList(false, ImmutableBaseBlocked.createSafeList(elements, true, false));
        return new ImmutableBaseBlocked(this.identifier, this.blocked, newValue, this.users);
    }

    public final ImmutableBaseBlocked withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseBlocked.createUnmodifiableList(false, ImmutableBaseBlocked.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseBlocked(this.identifier, this.blocked, this.chats, newValue);
    }

    public final ImmutableBaseBlocked withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseBlocked.createUnmodifiableList(false, ImmutableBaseBlocked.createSafeList(elements, true, false));
        return new ImmutableBaseBlocked(this.identifier, this.blocked, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseBlocked && this.equalTo(0, (ImmutableBaseBlocked)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseBlocked another) {
        return this.identifier == another.identifier && this.blocked.equals(another.blocked) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.blocked.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseBlocked{identifier=" + this.identifier + ", blocked=" + this.blocked + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableBaseBlocked copyOf(BaseBlocked instance) {
        if (instance instanceof ImmutableBaseBlocked) {
            return (ImmutableBaseBlocked)instance;
        }
        return ImmutableBaseBlocked.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<PeerBlocked> blocked = new ArrayList<PeerBlocked>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(Blocked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseBlocked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Blocked instance;
            long bits = 0L;
            if (object instanceof Blocked) {
                instance = (Blocked)object;
                if ((bits & 4L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllBlocked(instance.blocked());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 8L;
                }
            }
            if (object instanceof BaseBlocked) {
                instance = (BaseBlocked)object;
                if ((bits & 4L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllBlocked(instance.blocked());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 8L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addBlocked(PeerBlocked element) {
            this.blocked.add(Objects.requireNonNull(element, "blocked element"));
            return this;
        }

        public final Builder addBlocked(PeerBlocked ... elements) {
            for (PeerBlocked element : elements) {
                this.blocked.add(Objects.requireNonNull(element, "blocked element"));
            }
            return this;
        }

        public final Builder blocked(Iterable<? extends PeerBlocked> elements) {
            this.blocked.clear();
            return this.addAllBlocked(elements);
        }

        public final Builder addAllBlocked(Iterable<? extends PeerBlocked> elements) {
            for (PeerBlocked peerBlocked : elements) {
                this.blocked.add(Objects.requireNonNull(peerBlocked, "blocked element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseBlocked build() {
            return new ImmutableBaseBlocked(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

