/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Contact;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.contacts.BaseContacts;
import telegram4j.tl.contacts.Contacts;

public final class ImmutableBaseContacts
implements BaseContacts {
    private final int identifier;
    private final List<Contact> contacts;
    private final int savedCount;
    private final List<User> users;

    private ImmutableBaseContacts(int savedCount) {
        this.savedCount = savedCount;
        this.contacts = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = BaseContacts.super.identifier();
    }

    private ImmutableBaseContacts(Builder builder) {
        this.contacts = ImmutableBaseContacts.createUnmodifiableList(true, builder.contacts);
        this.savedCount = builder.savedCount;
        this.users = ImmutableBaseContacts.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseContacts.super.identifier();
    }

    private ImmutableBaseContacts(int identifier, List<Contact> contacts, int savedCount, List<User> users) {
        this.identifier = identifier;
        this.contacts = contacts;
        this.savedCount = savedCount;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Contact> contacts() {
        return this.contacts;
    }

    @Override
    public int savedCount() {
        return this.savedCount;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseContacts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseContacts(value, this.contacts, this.savedCount, this.users);
    }

    public final ImmutableBaseContacts withContacts(Contact ... elements) {
        List<Contact> newValue = ImmutableBaseContacts.createUnmodifiableList(false, ImmutableBaseContacts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseContacts(this.identifier, newValue, this.savedCount, this.users);
    }

    public final ImmutableBaseContacts withContacts(Iterable<? extends Contact> elements) {
        if (this.contacts == elements) {
            return this;
        }
        List<Contact> newValue = ImmutableBaseContacts.createUnmodifiableList(false, ImmutableBaseContacts.createSafeList(elements, true, false));
        return new ImmutableBaseContacts(this.identifier, newValue, this.savedCount, this.users);
    }

    public final ImmutableBaseContacts withSavedCount(int value) {
        if (this.savedCount == value) {
            return this;
        }
        return new ImmutableBaseContacts(this.identifier, this.contacts, value, this.users);
    }

    public final ImmutableBaseContacts withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseContacts.createUnmodifiableList(false, ImmutableBaseContacts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseContacts(this.identifier, this.contacts, this.savedCount, newValue);
    }

    public final ImmutableBaseContacts withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseContacts.createUnmodifiableList(false, ImmutableBaseContacts.createSafeList(elements, true, false));
        return new ImmutableBaseContacts(this.identifier, this.contacts, this.savedCount, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseContacts && this.equalTo(0, (ImmutableBaseContacts)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseContacts another) {
        return this.identifier == another.identifier && this.contacts.equals(another.contacts) && this.savedCount == another.savedCount && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.contacts.hashCode();
        h += (h << 5) + this.savedCount;
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseContacts{identifier=" + this.identifier + ", contacts=" + this.contacts + ", savedCount=" + this.savedCount + ", users=" + this.users + "}";
    }

    public static ImmutableBaseContacts of(int savedCount) {
        return new ImmutableBaseContacts(savedCount);
    }

    public static ImmutableBaseContacts copyOf(BaseContacts instance) {
        if (instance instanceof ImmutableBaseContacts) {
            return (ImmutableBaseContacts)instance;
        }
        return ImmutableBaseContacts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SAVED_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private List<Contact> contacts = new ArrayList<Contact>();
        private int savedCount;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(BaseContacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Contacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Contacts instance;
            long bits = 0L;
            if (object instanceof BaseContacts) {
                instance = (BaseContacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.savedCount(instance.savedCount());
                this.addAllContacts(instance.contacts());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Contacts) {
                instance = (Contacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addContact(Contact element) {
            this.contacts.add(Objects.requireNonNull(element, "contacts element"));
            return this;
        }

        public final Builder addContacts(Contact ... elements) {
            for (Contact element : elements) {
                this.contacts.add(Objects.requireNonNull(element, "contacts element"));
            }
            return this;
        }

        public final Builder contacts(Iterable<? extends Contact> elements) {
            this.contacts.clear();
            return this.addAllContacts(elements);
        }

        public final Builder addAllContacts(Iterable<? extends Contact> elements) {
            for (Contact contact : elements) {
                this.contacts.add(Objects.requireNonNull(contact, "contacts element"));
            }
            return this;
        }

        public final Builder savedCount(int savedCount) {
            this.savedCount = savedCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseContacts build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseContacts(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("savedCount");
            }
            return "Cannot build BaseContacts, some of required attributes are not set " + attributes;
        }
    }
}

