/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.TopPeerCategoryPeers;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.contacts.BaseTopPeers;
import telegram4j.tl.contacts.TopPeers;

public final class ImmutableBaseTopPeers
implements BaseTopPeers {
    private final int identifier;
    private final List<TopPeerCategoryPeers> categories;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableBaseTopPeers(Builder builder) {
        this.categories = ImmutableBaseTopPeers.createUnmodifiableList(true, builder.categories);
        this.chats = ImmutableBaseTopPeers.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBaseTopPeers.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseTopPeers.super.identifier();
    }

    private ImmutableBaseTopPeers(int identifier, List<TopPeerCategoryPeers> categories, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.categories = categories;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<TopPeerCategoryPeers> categories() {
        return this.categories;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseTopPeers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseTopPeers(value, this.categories, this.chats, this.users);
    }

    public final ImmutableBaseTopPeers withCategories(TopPeerCategoryPeers ... elements) {
        List<TopPeerCategoryPeers> newValue = ImmutableBaseTopPeers.createUnmodifiableList(false, ImmutableBaseTopPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseTopPeers(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableBaseTopPeers withCategories(Iterable<? extends TopPeerCategoryPeers> elements) {
        if (this.categories == elements) {
            return this;
        }
        List<TopPeerCategoryPeers> newValue = ImmutableBaseTopPeers.createUnmodifiableList(false, ImmutableBaseTopPeers.createSafeList(elements, true, false));
        return new ImmutableBaseTopPeers(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableBaseTopPeers withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseTopPeers.createUnmodifiableList(false, ImmutableBaseTopPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseTopPeers(this.identifier, this.categories, newValue, this.users);
    }

    public final ImmutableBaseTopPeers withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseTopPeers.createUnmodifiableList(false, ImmutableBaseTopPeers.createSafeList(elements, true, false));
        return new ImmutableBaseTopPeers(this.identifier, this.categories, newValue, this.users);
    }

    public final ImmutableBaseTopPeers withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseTopPeers.createUnmodifiableList(false, ImmutableBaseTopPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseTopPeers(this.identifier, this.categories, this.chats, newValue);
    }

    public final ImmutableBaseTopPeers withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseTopPeers.createUnmodifiableList(false, ImmutableBaseTopPeers.createSafeList(elements, true, false));
        return new ImmutableBaseTopPeers(this.identifier, this.categories, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseTopPeers && this.equalTo(0, (ImmutableBaseTopPeers)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseTopPeers another) {
        return this.identifier == another.identifier && this.categories.equals(another.categories) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.categories.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseTopPeers{identifier=" + this.identifier + ", categories=" + this.categories + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableBaseTopPeers copyOf(BaseTopPeers instance) {
        if (instance instanceof ImmutableBaseTopPeers) {
            return (ImmutableBaseTopPeers)instance;
        }
        return ImmutableBaseTopPeers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<TopPeerCategoryPeers> categories = new ArrayList<TopPeerCategoryPeers>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(BaseTopPeers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TopPeers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TopPeers instance;
            long bits = 0L;
            if (object instanceof BaseTopPeers) {
                instance = (BaseTopPeers)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllCategories(instance.categories());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TopPeers) {
                instance = (TopPeers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addCategory(TopPeerCategoryPeers element) {
            this.categories.add(Objects.requireNonNull(element, "categories element"));
            return this;
        }

        public final Builder addCategories(TopPeerCategoryPeers ... elements) {
            for (TopPeerCategoryPeers element : elements) {
                this.categories.add(Objects.requireNonNull(element, "categories element"));
            }
            return this;
        }

        public final Builder categories(Iterable<? extends TopPeerCategoryPeers> elements) {
            this.categories.clear();
            return this.addAllCategories(elements);
        }

        public final Builder addAllCategories(Iterable<? extends TopPeerCategoryPeers> elements) {
            for (TopPeerCategoryPeers topPeerCategoryPeers : elements) {
                this.categories.add(Objects.requireNonNull(topPeerCategoryPeers, "categories element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseTopPeers build() {
            return new ImmutableBaseTopPeers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

