/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.PeerBlocked;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.contacts.Blocked;
import telegram4j.tl.contacts.BlockedSlice;

public final class ImmutableBlockedSlice
implements BlockedSlice {
    private final int identifier;
    private final int count;
    private final List<PeerBlocked> blocked;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableBlockedSlice(int count) {
        this.count = count;
        this.blocked = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = BlockedSlice.super.identifier();
    }

    private ImmutableBlockedSlice(Builder builder) {
        this.count = builder.count;
        this.blocked = ImmutableBlockedSlice.createUnmodifiableList(true, builder.blocked);
        this.chats = ImmutableBlockedSlice.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBlockedSlice.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BlockedSlice.super.identifier();
    }

    private ImmutableBlockedSlice(int identifier, int count, List<PeerBlocked> blocked, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.count = count;
        this.blocked = blocked;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<PeerBlocked> blocked() {
        return this.blocked;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBlockedSlice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBlockedSlice(value, this.count, this.blocked, this.chats, this.users);
    }

    public final ImmutableBlockedSlice withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableBlockedSlice(this.identifier, value, this.blocked, this.chats, this.users);
    }

    public final ImmutableBlockedSlice withBlocked(PeerBlocked ... elements) {
        List<PeerBlocked> newValue = ImmutableBlockedSlice.createUnmodifiableList(false, ImmutableBlockedSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBlockedSlice(this.identifier, this.count, newValue, this.chats, this.users);
    }

    public final ImmutableBlockedSlice withBlocked(Iterable<? extends PeerBlocked> elements) {
        if (this.blocked == elements) {
            return this;
        }
        List<PeerBlocked> newValue = ImmutableBlockedSlice.createUnmodifiableList(false, ImmutableBlockedSlice.createSafeList(elements, true, false));
        return new ImmutableBlockedSlice(this.identifier, this.count, newValue, this.chats, this.users);
    }

    public final ImmutableBlockedSlice withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBlockedSlice.createUnmodifiableList(false, ImmutableBlockedSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBlockedSlice(this.identifier, this.count, this.blocked, newValue, this.users);
    }

    public final ImmutableBlockedSlice withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBlockedSlice.createUnmodifiableList(false, ImmutableBlockedSlice.createSafeList(elements, true, false));
        return new ImmutableBlockedSlice(this.identifier, this.count, this.blocked, newValue, this.users);
    }

    public final ImmutableBlockedSlice withUsers(User ... elements) {
        List<User> newValue = ImmutableBlockedSlice.createUnmodifiableList(false, ImmutableBlockedSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBlockedSlice(this.identifier, this.count, this.blocked, this.chats, newValue);
    }

    public final ImmutableBlockedSlice withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBlockedSlice.createUnmodifiableList(false, ImmutableBlockedSlice.createSafeList(elements, true, false));
        return new ImmutableBlockedSlice(this.identifier, this.count, this.blocked, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlockedSlice && this.equalTo(0, (ImmutableBlockedSlice)another);
    }

    private boolean equalTo(int synthetic, ImmutableBlockedSlice another) {
        return this.identifier == another.identifier && this.count == another.count && this.blocked.equals(another.blocked) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.blocked.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BlockedSlice{identifier=" + this.identifier + ", count=" + this.count + ", blocked=" + this.blocked + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableBlockedSlice of(int count) {
        return new ImmutableBlockedSlice(count);
    }

    public static ImmutableBlockedSlice copyOf(BlockedSlice instance) {
        if (instance instanceof ImmutableBlockedSlice) {
            return (ImmutableBlockedSlice)instance;
        }
        return ImmutableBlockedSlice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<PeerBlocked> blocked = new ArrayList<PeerBlocked>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(Blocked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BlockedSlice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Blocked instance;
            long bits = 0L;
            if (object instanceof Blocked) {
                instance = (Blocked)object;
                if ((bits & 4L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllBlocked(instance.blocked());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 8L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BlockedSlice) {
                instance = (BlockedSlice)object;
                this.count(instance.count());
                if ((bits & 4L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllBlocked(instance.blocked());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 8L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addBlocked(PeerBlocked element) {
            this.blocked.add(Objects.requireNonNull(element, "blocked element"));
            return this;
        }

        public final Builder addBlocked(PeerBlocked ... elements) {
            for (PeerBlocked element : elements) {
                this.blocked.add(Objects.requireNonNull(element, "blocked element"));
            }
            return this;
        }

        public final Builder blocked(Iterable<? extends PeerBlocked> elements) {
            this.blocked.clear();
            return this.addAllBlocked(elements);
        }

        public final Builder addAllBlocked(Iterable<? extends PeerBlocked> elements) {
            for (PeerBlocked peerBlocked : elements) {
                this.blocked.add(Objects.requireNonNull(peerBlocked, "blocked element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBlockedSlice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlockedSlice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build BlockedSlice, some of required attributes are not set " + attributes;
        }
    }
}

