/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.Peer;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.contacts.Found;

public final class ImmutableFound
implements Found {
    private final int identifier;
    private final List<Peer> myResults;
    private final List<Peer> results;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableFound(Builder builder) {
        this.myResults = ImmutableFound.createUnmodifiableList(true, builder.myResults);
        this.results = ImmutableFound.createUnmodifiableList(true, builder.results);
        this.chats = ImmutableFound.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableFound.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : Found.super.identifier();
    }

    private ImmutableFound(int identifier, List<Peer> myResults, List<Peer> results, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.myResults = myResults;
        this.results = results;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Peer> myResults() {
        return this.myResults;
    }

    @Override
    public List<Peer> results() {
        return this.results;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableFound withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFound(value, this.myResults, this.results, this.chats, this.users);
    }

    public final ImmutableFound withMyResults(Peer ... elements) {
        List<Peer> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFound(this.identifier, newValue, this.results, this.chats, this.users);
    }

    public final ImmutableFound withMyResults(Iterable<? extends Peer> elements) {
        if (this.myResults == elements) {
            return this;
        }
        List<Peer> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(elements, true, false));
        return new ImmutableFound(this.identifier, newValue, this.results, this.chats, this.users);
    }

    public final ImmutableFound withResults(Peer ... elements) {
        List<Peer> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFound(this.identifier, this.myResults, newValue, this.chats, this.users);
    }

    public final ImmutableFound withResults(Iterable<? extends Peer> elements) {
        if (this.results == elements) {
            return this;
        }
        List<Peer> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(elements, true, false));
        return new ImmutableFound(this.identifier, this.myResults, newValue, this.chats, this.users);
    }

    public final ImmutableFound withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFound(this.identifier, this.myResults, this.results, newValue, this.users);
    }

    public final ImmutableFound withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(elements, true, false));
        return new ImmutableFound(this.identifier, this.myResults, this.results, newValue, this.users);
    }

    public final ImmutableFound withUsers(User ... elements) {
        List<User> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFound(this.identifier, this.myResults, this.results, this.chats, newValue);
    }

    public final ImmutableFound withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableFound.createUnmodifiableList(false, ImmutableFound.createSafeList(elements, true, false));
        return new ImmutableFound(this.identifier, this.myResults, this.results, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFound && this.equalTo(0, (ImmutableFound)another);
    }

    private boolean equalTo(int synthetic, ImmutableFound another) {
        return this.identifier == another.identifier && this.myResults.equals(another.myResults) && this.results.equals(another.results) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.myResults.hashCode();
        h += (h << 5) + this.results.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "Found{identifier=" + this.identifier + ", myResults=" + this.myResults + ", results=" + this.results + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableFound copyOf(Found instance) {
        if (instance instanceof ImmutableFound) {
            return (ImmutableFound)instance;
        }
        return ImmutableFound.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Peer> myResults = new ArrayList<Peer>();
        private List<Peer> results = new ArrayList<Peer>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Found instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Found) {
                instance = (Found)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllResults(instance.results());
                this.addAllUsers(instance.users());
                this.addAllMyResults(instance.myResults());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMyResult(Peer element) {
            this.myResults.add(Objects.requireNonNull(element, "myResults element"));
            return this;
        }

        public final Builder addMyResults(Peer ... elements) {
            for (Peer element : elements) {
                this.myResults.add(Objects.requireNonNull(element, "myResults element"));
            }
            return this;
        }

        public final Builder myResults(Iterable<? extends Peer> elements) {
            this.myResults.clear();
            return this.addAllMyResults(elements);
        }

        public final Builder addAllMyResults(Iterable<? extends Peer> elements) {
            for (Peer peer : elements) {
                this.myResults.add(Objects.requireNonNull(peer, "myResults element"));
            }
            return this;
        }

        public final Builder addResult(Peer element) {
            this.results.add(Objects.requireNonNull(element, "results element"));
            return this;
        }

        public final Builder addResults(Peer ... elements) {
            for (Peer element : elements) {
                this.results.add(Objects.requireNonNull(element, "results element"));
            }
            return this;
        }

        public final Builder results(Iterable<? extends Peer> elements) {
            this.results.clear();
            return this.addAllResults(elements);
        }

        public final Builder addAllResults(Iterable<? extends Peer> elements) {
            for (Peer peer : elements) {
                this.results.add(Objects.requireNonNull(peer, "results element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableFound build() {
            return new ImmutableFound(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

