/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ImportedContact;
import telegram4j.tl.PopularContact;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.contacts.ImportedContacts;

public final class ImmutableImportedContacts
implements ImportedContacts {
    private final int identifier;
    private final List<ImportedContact> imported;
    private final List<PopularContact> popularInvites;
    private final List<Long> retryContacts;
    private final List<User> users;

    private ImmutableImportedContacts(Builder builder) {
        this.imported = ImmutableImportedContacts.createUnmodifiableList(true, builder.imported);
        this.popularInvites = ImmutableImportedContacts.createUnmodifiableList(true, builder.popularInvites);
        this.retryContacts = ImmutableImportedContacts.createUnmodifiableList(true, builder.retryContacts);
        this.users = ImmutableImportedContacts.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ImportedContacts.super.identifier();
    }

    private ImmutableImportedContacts(int identifier, List<ImportedContact> imported, List<PopularContact> popularInvites, List<Long> retryContacts, List<User> users) {
        this.identifier = identifier;
        this.imported = imported;
        this.popularInvites = popularInvites;
        this.retryContacts = retryContacts;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<ImportedContact> imported() {
        return this.imported;
    }

    @Override
    public List<PopularContact> popularInvites() {
        return this.popularInvites;
    }

    @Override
    public List<Long> retryContacts() {
        return this.retryContacts;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableImportedContacts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableImportedContacts(value, this.imported, this.popularInvites, this.retryContacts, this.users);
    }

    public final ImmutableImportedContacts withImported(ImportedContact ... elements) {
        List<ImportedContact> newValue = ImmutableImportedContacts.createUnmodifiableList(false, ImmutableImportedContacts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImportedContacts(this.identifier, newValue, this.popularInvites, this.retryContacts, this.users);
    }

    public final ImmutableImportedContacts withImported(Iterable<? extends ImportedContact> elements) {
        if (this.imported == elements) {
            return this;
        }
        List<ImportedContact> newValue = ImmutableImportedContacts.createUnmodifiableList(false, ImmutableImportedContacts.createSafeList(elements, true, false));
        return new ImmutableImportedContacts(this.identifier, newValue, this.popularInvites, this.retryContacts, this.users);
    }

    public final ImmutableImportedContacts withPopularInvites(PopularContact ... elements) {
        List<PopularContact> newValue = ImmutableImportedContacts.createUnmodifiableList(false, ImmutableImportedContacts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImportedContacts(this.identifier, this.imported, newValue, this.retryContacts, this.users);
    }

    public final ImmutableImportedContacts withPopularInvites(Iterable<? extends PopularContact> elements) {
        if (this.popularInvites == elements) {
            return this;
        }
        List<PopularContact> newValue = ImmutableImportedContacts.createUnmodifiableList(false, ImmutableImportedContacts.createSafeList(elements, true, false));
        return new ImmutableImportedContacts(this.identifier, this.imported, newValue, this.retryContacts, this.users);
    }

    public final ImmutableImportedContacts withRetryContacts(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableImportedContacts.createUnmodifiableList(false, wrappedList);
        return new ImmutableImportedContacts(this.identifier, this.imported, this.popularInvites, newValue, this.users);
    }

    public final ImmutableImportedContacts withRetryContacts(Iterable<Long> elements) {
        if (this.retryContacts == elements) {
            return this;
        }
        List<Long> newValue = ImmutableImportedContacts.createUnmodifiableList(false, ImmutableImportedContacts.createSafeList(elements, true, false));
        return new ImmutableImportedContacts(this.identifier, this.imported, this.popularInvites, newValue, this.users);
    }

    public final ImmutableImportedContacts withUsers(User ... elements) {
        List<User> newValue = ImmutableImportedContacts.createUnmodifiableList(false, ImmutableImportedContacts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImportedContacts(this.identifier, this.imported, this.popularInvites, this.retryContacts, newValue);
    }

    public final ImmutableImportedContacts withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableImportedContacts.createUnmodifiableList(false, ImmutableImportedContacts.createSafeList(elements, true, false));
        return new ImmutableImportedContacts(this.identifier, this.imported, this.popularInvites, this.retryContacts, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportedContacts && this.equalTo(0, (ImmutableImportedContacts)another);
    }

    private boolean equalTo(int synthetic, ImmutableImportedContacts another) {
        return this.identifier == another.identifier && this.imported.equals(another.imported) && this.popularInvites.equals(another.popularInvites) && this.retryContacts.equals(another.retryContacts) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.imported.hashCode();
        h += (h << 5) + this.popularInvites.hashCode();
        h += (h << 5) + this.retryContacts.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ImportedContacts{identifier=" + this.identifier + ", imported=" + this.imported + ", popularInvites=" + this.popularInvites + ", retryContacts=" + this.retryContacts + ", users=" + this.users + "}";
    }

    public static ImmutableImportedContacts copyOf(ImportedContacts instance) {
        if (instance instanceof ImmutableImportedContacts) {
            return (ImmutableImportedContacts)instance;
        }
        return ImmutableImportedContacts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<ImportedContact> imported = new ArrayList<ImportedContact>();
        private List<PopularContact> popularInvites = new ArrayList<PopularContact>();
        private List<Long> retryContacts = new ArrayList<Long>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(ImportedContacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ImportedContacts instance;
            long bits = 0L;
            if (object instanceof ImportedContacts) {
                instance = (ImportedContacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllPopularInvites(instance.popularInvites());
                this.addAllUsers(instance.users());
                this.addAllImported(instance.imported());
                this.addAllRetryContacts(instance.retryContacts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addImported(ImportedContact element) {
            this.imported.add(Objects.requireNonNull(element, "imported element"));
            return this;
        }

        public final Builder addImported(ImportedContact ... elements) {
            for (ImportedContact element : elements) {
                this.imported.add(Objects.requireNonNull(element, "imported element"));
            }
            return this;
        }

        public final Builder imported(Iterable<? extends ImportedContact> elements) {
            this.imported.clear();
            return this.addAllImported(elements);
        }

        public final Builder addAllImported(Iterable<? extends ImportedContact> elements) {
            for (ImportedContact importedContact : elements) {
                this.imported.add(Objects.requireNonNull(importedContact, "imported element"));
            }
            return this;
        }

        public final Builder addPopularInvite(PopularContact element) {
            this.popularInvites.add(Objects.requireNonNull(element, "popularInvites element"));
            return this;
        }

        public final Builder addPopularInvites(PopularContact ... elements) {
            for (PopularContact element : elements) {
                this.popularInvites.add(Objects.requireNonNull(element, "popularInvites element"));
            }
            return this;
        }

        public final Builder popularInvites(Iterable<? extends PopularContact> elements) {
            this.popularInvites.clear();
            return this.addAllPopularInvites(elements);
        }

        public final Builder addAllPopularInvites(Iterable<? extends PopularContact> elements) {
            for (PopularContact popularContact : elements) {
                this.popularInvites.add(Objects.requireNonNull(popularContact, "popularInvites element"));
            }
            return this;
        }

        public final Builder addRetryContact(long element) {
            this.retryContacts.add(element);
            return this;
        }

        public final Builder addRetryContacts(long ... elements) {
            for (long element : elements) {
                this.retryContacts.add(element);
            }
            return this;
        }

        public final Builder retryContacts(Iterable<Long> elements) {
            this.retryContacts.clear();
            return this.addAllRetryContacts(elements);
        }

        public final Builder addAllRetryContacts(Iterable<Long> elements) {
            for (Long element : elements) {
                this.retryContacts.add(Objects.requireNonNull(element, "retryContacts element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableImportedContacts build() {
            return new ImmutableImportedContacts(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

