/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.Peer;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.contacts.ResolvedPeer;

public final class ImmutableResolvedPeer
implements ResolvedPeer {
    private final int identifier;
    private final Peer peer;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableResolvedPeer(Peer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = ResolvedPeer.super.identifier();
    }

    private ImmutableResolvedPeer(Builder builder) {
        this.peer = builder.peer;
        this.chats = ImmutableResolvedPeer.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableResolvedPeer.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResolvedPeer.super.identifier();
    }

    private ImmutableResolvedPeer(int identifier, Peer peer, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.peer = peer;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableResolvedPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResolvedPeer(value, this.peer, this.chats, this.users);
    }

    public final ImmutableResolvedPeer withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableResolvedPeer(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableResolvedPeer withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableResolvedPeer.createUnmodifiableList(false, ImmutableResolvedPeer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableResolvedPeer(this.identifier, this.peer, newValue, this.users);
    }

    public final ImmutableResolvedPeer withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableResolvedPeer.createUnmodifiableList(false, ImmutableResolvedPeer.createSafeList(elements, true, false));
        return new ImmutableResolvedPeer(this.identifier, this.peer, newValue, this.users);
    }

    public final ImmutableResolvedPeer withUsers(User ... elements) {
        List<User> newValue = ImmutableResolvedPeer.createUnmodifiableList(false, ImmutableResolvedPeer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableResolvedPeer(this.identifier, this.peer, this.chats, newValue);
    }

    public final ImmutableResolvedPeer withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableResolvedPeer.createUnmodifiableList(false, ImmutableResolvedPeer.createSafeList(elements, true, false));
        return new ImmutableResolvedPeer(this.identifier, this.peer, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResolvedPeer && this.equalTo(0, (ImmutableResolvedPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableResolvedPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ResolvedPeer{identifier=" + this.identifier + ", peer=" + this.peer + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableResolvedPeer of(Peer peer) {
        return new ImmutableResolvedPeer(peer);
    }

    public static ImmutableResolvedPeer copyOf(ResolvedPeer instance) {
        if (instance instanceof ImmutableResolvedPeer) {
            return (ImmutableResolvedPeer)instance;
        }
        return ImmutableResolvedPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(ResolvedPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResolvedPeer instance;
            long bits = 0L;
            if (object instanceof ResolvedPeer) {
                instance = (ResolvedPeer)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableResolvedPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResolvedPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ResolvedPeer, some of required attributes are not set " + attributes;
        }
    }
}

