/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Document;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.AppUpdate;
import telegram4j.tl.help.BaseAppUpdate;

public final class ImmutableBaseAppUpdate
implements BaseAppUpdate {
    private final int identifier;
    private final int flags;
    private final boolean canNotSkip;
    private final int id;
    private final String version;
    private final String text;
    private final List<MessageEntity> entities;
    @Nullable
    private final Document document;
    @Nullable
    private final String url;
    @Nullable
    private final Document sticker;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseAppUpdate(int id, String version, String text) {
        this.id = id;
        this.version = Objects.requireNonNull(version, "version");
        this.text = Objects.requireNonNull(text, "text");
        this.entities = Collections.emptyList();
        this.document = null;
        this.url = null;
        this.sticker = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canNotSkip = this.initShim.canNotSkip();
        this.initShim = null;
    }

    private ImmutableBaseAppUpdate(Builder builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.text = builder.text;
        this.entities = ImmutableBaseAppUpdate.createUnmodifiableList(true, builder.entities);
        this.document = builder.document;
        this.url = builder.url;
        this.sticker = builder.sticker;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.canNotSkipIsSet()) {
            this.initShim.canNotSkip(builder.canNotSkip);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canNotSkip = this.initShim.canNotSkip();
        this.initShim = null;
    }

    private ImmutableBaseAppUpdate(int identifier, int flags, boolean canNotSkip, int id, String version, String text, List<MessageEntity> entities, @Nullable Document document, @Nullable String url, @Nullable Document sticker) {
        this.identifier = identifier;
        this.flags = flags;
        this.canNotSkip = canNotSkip;
        this.id = id;
        this.version = version;
        this.text = text;
        this.entities = entities;
        this.document = document;
        this.url = url;
        this.sticker = sticker;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseAppUpdate.super.identifier();
    }

    private int flagsInitialize() {
        return BaseAppUpdate.super.flags();
    }

    private boolean canNotSkipInitialize() {
        return BaseAppUpdate.super.canNotSkip();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean canNotSkip() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canNotSkip() : this.canNotSkip;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public Document document() {
        return this.document;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public Document sticker() {
        return this.sticker;
    }

    public final ImmutableBaseAppUpdate withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseAppUpdate(value, this.flags, this.canNotSkip, this.id, this.version, this.text, this.entities, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, value, this.canNotSkip, this.id, this.version, this.text, this.entities, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withCanNotSkip(boolean value) {
        if (this.canNotSkip == value) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, value, this.id, this.version, this.text, this.entities, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, value, this.version, this.text, this.entities, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, this.id, newValue, this.text, this.entities, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, this.id, this.version, newValue, this.entities, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withEntities(MessageEntity ... elements) {
        List<MessageEntity> newValue = ImmutableBaseAppUpdate.createUnmodifiableList(false, ImmutableBaseAppUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, this.id, this.version, this.text, newValue, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withEntities(Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = ImmutableBaseAppUpdate.createUnmodifiableList(false, ImmutableBaseAppUpdate.createSafeList(elements, true, false));
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, this.id, this.version, this.text, newValue, this.document, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withDocument(@Nullable Document value) {
        if (this.document == value) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, this.id, this.version, this.text, this.entities, value, this.url, this.sticker);
    }

    public final ImmutableBaseAppUpdate withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, this.id, this.version, this.text, this.entities, this.document, value, this.sticker);
    }

    public final ImmutableBaseAppUpdate withSticker(@Nullable Document value) {
        if (this.sticker == value) {
            return this;
        }
        return new ImmutableBaseAppUpdate(this.identifier, this.flags, this.canNotSkip, this.id, this.version, this.text, this.entities, this.document, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseAppUpdate && this.equalTo(0, (ImmutableBaseAppUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseAppUpdate another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.canNotSkip == another.canNotSkip && this.id == another.id && this.version.equals(another.version) && this.text.equals(another.text) && this.entities.equals(another.entities) && Objects.equals(this.document, another.document) && Objects.equals(this.url, another.url) && Objects.equals(this.sticker, another.sticker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.canNotSkip);
        h += (h << 5) + this.id;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.entities.hashCode();
        h += (h << 5) + Objects.hashCode(this.document);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.sticker);
        return h;
    }

    public String toString() {
        return "BaseAppUpdate{identifier=" + this.identifier + ", flags=" + this.flags + ", canNotSkip=" + this.canNotSkip + ", id=" + this.id + ", version=" + this.version + ", text=" + this.text + ", entities=" + this.entities + ", document=" + this.document + ", url=" + this.url + ", sticker=" + this.sticker + "}";
    }

    public static ImmutableBaseAppUpdate of(int id, String version, String text) {
        return new ImmutableBaseAppUpdate(id, version, text);
    }

    public static ImmutableBaseAppUpdate copyOf(BaseAppUpdate instance) {
        if (instance instanceof ImmutableBaseAppUpdate) {
            return (ImmutableBaseAppUpdate)instance;
        }
        return ImmutableBaseAppUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_TEXT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CAN_NOT_SKIP = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean canNotSkip;
        private int id;
        private String version;
        private String text;
        private List<MessageEntity> entities = new ArrayList<MessageEntity>();
        private Document document;
        private String url;
        private Document sticker;

        private Builder() {
        }

        public final Builder from(BaseAppUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AppUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AppUpdate instance;
            long bits = 0L;
            if (object instanceof BaseAppUpdate) {
                instance = (BaseAppUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.canNotSkip(instance.canNotSkip());
                this.addAllEntities(instance.entities());
                Document documentValue = instance.document();
                if (documentValue != null) {
                    this.document(documentValue);
                }
                this.flags(instance.flags());
                Document stickerValue = instance.sticker();
                if (stickerValue != null) {
                    this.sticker(stickerValue);
                }
                this.id(instance.id());
                this.text(instance.text());
                this.version(instance.version());
                String urlValue = instance.url();
                if (urlValue != null) {
                    this.url(urlValue);
                }
            }
            if (object instanceof AppUpdate) {
                instance = (AppUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder canNotSkip(boolean canNotSkip) {
            this.canNotSkip = canNotSkip;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(Iterable<? extends MessageEntity> elements) {
            this.entities.clear();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder document(@Nullable Document document) {
            this.document = document;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder sticker(@Nullable Document sticker) {
            this.sticker = sticker;
            return this;
        }

        public ImmutableBaseAppUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseAppUpdate(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean canNotSkipIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build BaseAppUpdate, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte canNotSkipBuildStage = 0;
        private boolean canNotSkip;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseAppUpdate.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseAppUpdate.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean canNotSkip() {
            if (this.canNotSkipBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canNotSkipBuildStage == 0) {
                this.canNotSkipBuildStage = (byte)-1;
                this.canNotSkip = ImmutableBaseAppUpdate.this.canNotSkipInitialize();
                this.canNotSkipBuildStage = 1;
            }
            return this.canNotSkip;
        }

        void canNotSkip(boolean canNotSkip) {
            this.canNotSkip = canNotSkip;
            this.canNotSkipBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.canNotSkipBuildStage == -1) {
                attributes.add("canNotSkip");
            }
            return "Cannot build BaseAppUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

