/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.BaseCountriesList;
import telegram4j.tl.help.CountriesList;
import telegram4j.tl.help.Country;

public final class ImmutableBaseCountriesList
implements BaseCountriesList {
    private final int identifier;
    private final List<Country> countries;
    private final int hash;

    private ImmutableBaseCountriesList(int hash) {
        this.hash = hash;
        this.countries = Collections.emptyList();
        this.identifier = BaseCountriesList.super.identifier();
    }

    private ImmutableBaseCountriesList(Builder builder) {
        this.countries = ImmutableBaseCountriesList.createUnmodifiableList(true, builder.countries);
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseCountriesList.super.identifier();
    }

    private ImmutableBaseCountriesList(int identifier, List<Country> countries, int hash) {
        this.identifier = identifier;
        this.countries = countries;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Country> countries() {
        return this.countries;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    public final ImmutableBaseCountriesList withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseCountriesList(value, this.countries, this.hash);
    }

    public final ImmutableBaseCountriesList withCountries(Country ... elements) {
        List<Country> newValue = ImmutableBaseCountriesList.createUnmodifiableList(false, ImmutableBaseCountriesList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseCountriesList(this.identifier, newValue, this.hash);
    }

    public final ImmutableBaseCountriesList withCountries(Iterable<? extends Country> elements) {
        if (this.countries == elements) {
            return this;
        }
        List<Country> newValue = ImmutableBaseCountriesList.createUnmodifiableList(false, ImmutableBaseCountriesList.createSafeList(elements, true, false));
        return new ImmutableBaseCountriesList(this.identifier, newValue, this.hash);
    }

    public final ImmutableBaseCountriesList withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseCountriesList(this.identifier, this.countries, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseCountriesList && this.equalTo(0, (ImmutableBaseCountriesList)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseCountriesList another) {
        return this.identifier == another.identifier && this.countries.equals(another.countries) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.countries.hashCode();
        h += (h << 5) + this.hash;
        return h;
    }

    public String toString() {
        return "BaseCountriesList{identifier=" + this.identifier + ", countries=" + this.countries + ", hash=" + this.hash + "}";
    }

    public static ImmutableBaseCountriesList of(int hash) {
        return new ImmutableBaseCountriesList(hash);
    }

    public static ImmutableBaseCountriesList copyOf(BaseCountriesList instance) {
        if (instance instanceof ImmutableBaseCountriesList) {
            return (ImmutableBaseCountriesList)instance;
        }
        return ImmutableBaseCountriesList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private List<Country> countries = new ArrayList<Country>();
        private int hash;

        private Builder() {
        }

        public final Builder from(CountriesList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseCountriesList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CountriesList instance;
            long bits = 0L;
            if (object instanceof CountriesList) {
                instance = (CountriesList)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseCountriesList) {
                instance = (BaseCountriesList)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
                this.addAllCountries(instance.countries());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addCountry(Country element) {
            this.countries.add(Objects.requireNonNull(element, "countries element"));
            return this;
        }

        public final Builder addCountries(Country ... elements) {
            for (Country element : elements) {
                this.countries.add(Objects.requireNonNull(element, "countries element"));
            }
            return this;
        }

        public final Builder countries(Iterable<? extends Country> elements) {
            this.countries.clear();
            return this.addAllCountries(elements);
        }

        public final Builder addAllCountries(Iterable<? extends Country> elements) {
            for (Country country : elements) {
                this.countries.add(Objects.requireNonNull(country, "countries element"));
            }
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseCountriesList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseCountriesList(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseCountriesList, some of required attributes are not set " + attributes;
        }
    }
}

