/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.BasePassportConfig;
import telegram4j.tl.help.PassportConfig;

public final class ImmutableBasePassportConfig
implements BasePassportConfig {
    private final int identifier;
    private final int hash;
    private final DataJSON countriesLangs;

    private ImmutableBasePassportConfig(int hash, DataJSON countriesLangs) {
        this.hash = hash;
        this.countriesLangs = Objects.requireNonNull(countriesLangs, "countriesLangs");
        this.identifier = BasePassportConfig.super.identifier();
    }

    private ImmutableBasePassportConfig(Builder builder) {
        this.hash = builder.hash;
        this.countriesLangs = builder.countriesLangs;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BasePassportConfig.super.identifier();
    }

    private ImmutableBasePassportConfig(int identifier, int hash, DataJSON countriesLangs) {
        this.identifier = identifier;
        this.hash = hash;
        this.countriesLangs = countriesLangs;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    public DataJSON countriesLangs() {
        return this.countriesLangs;
    }

    public final ImmutableBasePassportConfig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePassportConfig(value, this.hash, this.countriesLangs);
    }

    public final ImmutableBasePassportConfig withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBasePassportConfig(this.identifier, value, this.countriesLangs);
    }

    public final ImmutableBasePassportConfig withCountriesLangs(DataJSON value) {
        if (this.countriesLangs == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "countriesLangs");
        return new ImmutableBasePassportConfig(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePassportConfig && this.equalTo(0, (ImmutableBasePassportConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePassportConfig another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.countriesLangs.equals(another.countriesLangs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.hash;
        h += (h << 5) + this.countriesLangs.hashCode();
        return h;
    }

    public String toString() {
        return "BasePassportConfig{identifier=" + this.identifier + ", hash=" + this.hash + ", countriesLangs=" + this.countriesLangs + "}";
    }

    public static ImmutableBasePassportConfig of(int hash, DataJSON countriesLangs) {
        return new ImmutableBasePassportConfig(hash, countriesLangs);
    }

    public static ImmutableBasePassportConfig copyOf(BasePassportConfig instance) {
        if (instance instanceof ImmutableBasePassportConfig) {
            return (ImmutableBasePassportConfig)instance;
        }
        return ImmutableBasePassportConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_COUNTRIES_LANGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int hash;
        private DataJSON countriesLangs;

        private Builder() {
        }

        public final Builder from(PassportConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BasePassportConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PassportConfig instance;
            long bits = 0L;
            if (object instanceof PassportConfig) {
                instance = (PassportConfig)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BasePassportConfig) {
                instance = (BasePassportConfig)object;
                this.countriesLangs(instance.countriesLangs());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder countriesLangs(DataJSON countriesLangs) {
            this.countriesLangs = Objects.requireNonNull(countriesLangs, "countriesLangs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBasePassportConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePassportConfig(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("countriesLangs");
            }
            return "Cannot build BasePassportConfig, some of required attributes are not set " + attributes;
        }
    }
}

