/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.Peer;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.BasePromoData;
import telegram4j.tl.help.PromoData;

public final class ImmutableBasePromoData
implements BasePromoData {
    private final int identifier;
    private final int flags;
    private final boolean proxy;
    private final int expires;
    private final Peer peer;
    private final List<Chat> chats;
    private final List<User> users;
    @Nullable
    private final String psaType;
    @Nullable
    private final String psaMessage;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBasePromoData(int expires, Peer peer) {
        this.expires = expires;
        this.peer = Objects.requireNonNull(peer, "peer");
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.psaType = null;
        this.psaMessage = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.proxy = this.initShim.proxy();
        this.initShim = null;
    }

    private ImmutableBasePromoData(Builder builder) {
        this.expires = builder.expires;
        this.peer = builder.peer;
        this.chats = ImmutableBasePromoData.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBasePromoData.createUnmodifiableList(true, builder.users);
        this.psaType = builder.psaType;
        this.psaMessage = builder.psaMessage;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.proxyIsSet()) {
            this.initShim.proxy(builder.proxy);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.proxy = this.initShim.proxy();
        this.initShim = null;
    }

    private ImmutableBasePromoData(int identifier, int flags, boolean proxy, int expires, Peer peer, List<Chat> chats, List<User> users, @Nullable String psaType, @Nullable String psaMessage) {
        this.identifier = identifier;
        this.flags = flags;
        this.proxy = proxy;
        this.expires = expires;
        this.peer = peer;
        this.chats = chats;
        this.users = users;
        this.psaType = psaType;
        this.psaMessage = psaMessage;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BasePromoData.super.identifier();
    }

    private int flagsInitialize() {
        return BasePromoData.super.flags();
    }

    private boolean proxyInitialize() {
        return BasePromoData.super.proxy();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean proxy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.proxy() : this.proxy;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    @Override
    @Nullable
    public String psaType() {
        return this.psaType;
    }

    @Override
    @Nullable
    public String psaMessage() {
        return this.psaMessage;
    }

    public final ImmutableBasePromoData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePromoData(value, this.flags, this.proxy, this.expires, this.peer, this.chats, this.users, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBasePromoData(this.identifier, value, this.proxy, this.expires, this.peer, this.chats, this.users, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withProxy(boolean value) {
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableBasePromoData(this.identifier, this.flags, value, this.expires, this.peer, this.chats, this.users, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, value, this.peer, this.chats, this.users, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, this.expires, newValue, this.chats, this.users, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBasePromoData.createUnmodifiableList(false, ImmutableBasePromoData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, this.expires, this.peer, newValue, this.users, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBasePromoData.createUnmodifiableList(false, ImmutableBasePromoData.createSafeList(elements, true, false));
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, this.expires, this.peer, newValue, this.users, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withUsers(User ... elements) {
        List<User> newValue = ImmutableBasePromoData.createUnmodifiableList(false, ImmutableBasePromoData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, this.expires, this.peer, this.chats, newValue, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBasePromoData.createUnmodifiableList(false, ImmutableBasePromoData.createSafeList(elements, true, false));
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, this.expires, this.peer, this.chats, newValue, this.psaType, this.psaMessage);
    }

    public final ImmutableBasePromoData withPsaType(@Nullable String value) {
        if (Objects.equals(this.psaType, value)) {
            return this;
        }
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, this.expires, this.peer, this.chats, this.users, value, this.psaMessage);
    }

    public final ImmutableBasePromoData withPsaMessage(@Nullable String value) {
        if (Objects.equals(this.psaMessage, value)) {
            return this;
        }
        return new ImmutableBasePromoData(this.identifier, this.flags, this.proxy, this.expires, this.peer, this.chats, this.users, this.psaType, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePromoData && this.equalTo(0, (ImmutableBasePromoData)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePromoData another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.proxy == another.proxy && this.expires == another.expires && this.peer.equals(another.peer) && this.chats.equals(another.chats) && this.users.equals(another.users) && Objects.equals(this.psaType, another.psaType) && Objects.equals(this.psaMessage, another.psaMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.proxy);
        h += (h << 5) + this.expires;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + Objects.hashCode(this.psaType);
        h += (h << 5) + Objects.hashCode(this.psaMessage);
        return h;
    }

    public String toString() {
        return "BasePromoData{identifier=" + this.identifier + ", flags=" + this.flags + ", proxy=" + this.proxy + ", expires=" + this.expires + ", peer=" + this.peer + ", chats=" + this.chats + ", users=" + this.users + ", psaType=" + this.psaType + ", psaMessage=" + this.psaMessage + "}";
    }

    public static ImmutableBasePromoData of(int expires, Peer peer) {
        return new ImmutableBasePromoData(expires, peer);
    }

    public static ImmutableBasePromoData copyOf(BasePromoData instance) {
        if (instance instanceof ImmutableBasePromoData) {
            return (ImmutableBasePromoData)instance;
        }
        return ImmutableBasePromoData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_EXPIRES = 1L;
        private static final long INIT_BIT_PEER = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PROXY = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean proxy;
        private int expires;
        private Peer peer;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();
        private String psaType;
        private String psaMessage;

        private Builder() {
        }

        public final Builder from(PromoData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BasePromoData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PromoData instance;
            long bits = 0L;
            if (object instanceof PromoData) {
                instance = (PromoData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BasePromoData) {
                instance = (BasePromoData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.proxy(instance.proxy());
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.addAllChats(instance.chats());
                String psaMessageValue = instance.psaMessage();
                if (psaMessageValue != null) {
                    this.psaMessage(psaMessageValue);
                }
                this.addAllUsers(instance.users());
                String psaTypeValue = instance.psaType();
                if (psaTypeValue != null) {
                    this.psaType(psaTypeValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder proxy(boolean proxy) {
            this.proxy = proxy;
            this.optBits |= 4L;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public final Builder psaType(@Nullable String psaType) {
            this.psaType = psaType;
            return this;
        }

        public final Builder psaMessage(@Nullable String psaMessage) {
            this.psaMessage = psaMessage;
            return this;
        }

        public ImmutableBasePromoData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePromoData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean proxyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build BasePromoData, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte proxyBuildStage = 0;
        private boolean proxy;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBasePromoData.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBasePromoData.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean proxy() {
            if (this.proxyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.proxyBuildStage == 0) {
                this.proxyBuildStage = (byte)-1;
                this.proxy = ImmutableBasePromoData.this.proxyInitialize();
                this.proxyBuildStage = 1;
            }
            return this.proxy;
        }

        void proxy(boolean proxy) {
            this.proxy = proxy;
            this.proxyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.proxyBuildStage == -1) {
                attributes.add("proxy");
            }
            return "Cannot build BasePromoData, attribute initializers form cycle " + attributes;
        }
    }
}

