/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.BaseTermsOfServiceUpdate;
import telegram4j.tl.help.TermsOfService;
import telegram4j.tl.help.TermsOfServiceUpdate;

public final class ImmutableBaseTermsOfServiceUpdate
implements BaseTermsOfServiceUpdate {
    private final int identifier;
    private final int expires;
    private final TermsOfService termsOfService;

    private ImmutableBaseTermsOfServiceUpdate(int expires, TermsOfService termsOfService) {
        this.expires = expires;
        this.termsOfService = Objects.requireNonNull(termsOfService, "termsOfService");
        this.identifier = BaseTermsOfServiceUpdate.super.identifier();
    }

    private ImmutableBaseTermsOfServiceUpdate(Builder builder) {
        this.expires = builder.expires;
        this.termsOfService = builder.termsOfService;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseTermsOfServiceUpdate.super.identifier();
    }

    private ImmutableBaseTermsOfServiceUpdate(int identifier, int expires, TermsOfService termsOfService) {
        this.identifier = identifier;
        this.expires = expires;
        this.termsOfService = termsOfService;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    @Override
    public TermsOfService termsOfService() {
        return this.termsOfService;
    }

    public final ImmutableBaseTermsOfServiceUpdate withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseTermsOfServiceUpdate(value, this.expires, this.termsOfService);
    }

    public final ImmutableBaseTermsOfServiceUpdate withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableBaseTermsOfServiceUpdate(this.identifier, value, this.termsOfService);
    }

    public final ImmutableBaseTermsOfServiceUpdate withTermsOfService(TermsOfService value) {
        if (this.termsOfService == value) {
            return this;
        }
        TermsOfService newValue = Objects.requireNonNull(value, "termsOfService");
        return new ImmutableBaseTermsOfServiceUpdate(this.identifier, this.expires, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseTermsOfServiceUpdate && this.equalTo(0, (ImmutableBaseTermsOfServiceUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseTermsOfServiceUpdate another) {
        return this.identifier == another.identifier && this.expires == another.expires && this.termsOfService.equals(another.termsOfService);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.expires;
        h += (h << 5) + this.termsOfService.hashCode();
        return h;
    }

    public String toString() {
        return "BaseTermsOfServiceUpdate{identifier=" + this.identifier + ", expires=" + this.expires + ", termsOfService=" + this.termsOfService + "}";
    }

    public static ImmutableBaseTermsOfServiceUpdate of(int expires, TermsOfService termsOfService) {
        return new ImmutableBaseTermsOfServiceUpdate(expires, termsOfService);
    }

    public static ImmutableBaseTermsOfServiceUpdate copyOf(BaseTermsOfServiceUpdate instance) {
        if (instance instanceof ImmutableBaseTermsOfServiceUpdate) {
            return (ImmutableBaseTermsOfServiceUpdate)instance;
        }
        return ImmutableBaseTermsOfServiceUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXPIRES = 1L;
        private static final long INIT_BIT_TERMS_OF_SERVICE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int expires;
        private TermsOfService termsOfService;

        private Builder() {
        }

        public final Builder from(BaseTermsOfServiceUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TermsOfServiceUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TermsOfServiceUpdate instance;
            long bits = 0L;
            if (object instanceof BaseTermsOfServiceUpdate) {
                instance = (BaseTermsOfServiceUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
                this.termsOfService(instance.termsOfService());
            }
            if (object instanceof TermsOfServiceUpdate) {
                instance = (TermsOfServiceUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder termsOfService(TermsOfService termsOfService) {
            this.termsOfService = Objects.requireNonNull(termsOfService, "termsOfService");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseTermsOfServiceUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseTermsOfServiceUpdate(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("termsOfService");
            }
            return "Cannot build BaseTermsOfServiceUpdate, some of required attributes are not set " + attributes;
        }
    }
}

