/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.BaseUserInfo;
import telegram4j.tl.help.UserInfo;

public final class ImmutableBaseUserInfo
implements BaseUserInfo {
    private final int identifier;
    private final String message;
    private final List<MessageEntity> entities;
    private final String author;
    private final int date;

    private ImmutableBaseUserInfo(String message, String author, int date) {
        this.message = Objects.requireNonNull(message, "message");
        this.author = Objects.requireNonNull(author, "author");
        this.date = date;
        this.entities = Collections.emptyList();
        this.identifier = BaseUserInfo.super.identifier();
    }

    private ImmutableBaseUserInfo(Builder builder) {
        this.message = builder.message;
        this.entities = ImmutableBaseUserInfo.createUnmodifiableList(true, builder.entities);
        this.author = builder.author;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseUserInfo.super.identifier();
    }

    private ImmutableBaseUserInfo(int identifier, String message, List<MessageEntity> entities, String author, int date) {
        this.identifier = identifier;
        this.message = message;
        this.entities = entities;
        this.author = author;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    public String author() {
        return this.author;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableBaseUserInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseUserInfo(value, this.message, this.entities, this.author, this.date);
    }

    public final ImmutableBaseUserInfo withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseUserInfo(this.identifier, newValue, this.entities, this.author, this.date);
    }

    public final ImmutableBaseUserInfo withEntities(MessageEntity ... elements) {
        List<MessageEntity> newValue = ImmutableBaseUserInfo.createUnmodifiableList(false, ImmutableBaseUserInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseUserInfo(this.identifier, this.message, newValue, this.author, this.date);
    }

    public final ImmutableBaseUserInfo withEntities(Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = ImmutableBaseUserInfo.createUnmodifiableList(false, ImmutableBaseUserInfo.createSafeList(elements, true, false));
        return new ImmutableBaseUserInfo(this.identifier, this.message, newValue, this.author, this.date);
    }

    public final ImmutableBaseUserInfo withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseUserInfo(this.identifier, this.message, this.entities, newValue, this.date);
    }

    public final ImmutableBaseUserInfo withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseUserInfo(this.identifier, this.message, this.entities, this.author, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseUserInfo && this.equalTo(0, (ImmutableBaseUserInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseUserInfo another) {
        return this.identifier == another.identifier && this.message.equals(another.message) && this.entities.equals(another.entities) && this.author.equals(another.author) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.entities.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "BaseUserInfo{identifier=" + this.identifier + ", message=" + this.message + ", entities=" + this.entities + ", author=" + this.author + ", date=" + this.date + "}";
    }

    public static ImmutableBaseUserInfo of(String message, String author, int date) {
        return new ImmutableBaseUserInfo(message, author, date);
    }

    public static ImmutableBaseUserInfo copyOf(BaseUserInfo instance) {
        if (instance instanceof ImmutableBaseUserInfo) {
            return (ImmutableBaseUserInfo)instance;
        }
        return ImmutableBaseUserInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_AUTHOR = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String message;
        private List<MessageEntity> entities = new ArrayList<MessageEntity>();
        private String author;
        private int date;

        private Builder() {
        }

        public final Builder from(UserInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseUserInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UserInfo instance;
            long bits = 0L;
            if (object instanceof UserInfo) {
                instance = (UserInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseUserInfo) {
                instance = (BaseUserInfo)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.message(instance.message());
                this.addAllEntities(instance.entities());
                this.author(instance.author());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(Iterable<? extends MessageEntity> elements) {
            this.entities.clear();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBaseUserInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseUserInfo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build BaseUserInfo, some of required attributes are not set " + attributes;
        }
    }
}

