/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.AccessPointRule;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.ConfigSimple;

public final class ImmutableConfigSimple
implements ConfigSimple {
    private final int identifier;
    private final int date;
    private final int expires;
    private final List<AccessPointRule> rules;

    private ImmutableConfigSimple(int date, int expires) {
        this.date = date;
        this.expires = expires;
        this.rules = Collections.emptyList();
        this.identifier = ConfigSimple.super.identifier();
    }

    private ImmutableConfigSimple(Builder builder) {
        this.date = builder.date;
        this.expires = builder.expires;
        this.rules = ImmutableConfigSimple.createUnmodifiableList(true, builder.rules);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ConfigSimple.super.identifier();
    }

    private ImmutableConfigSimple(int identifier, int date, int expires, List<AccessPointRule> rules) {
        this.identifier = identifier;
        this.date = date;
        this.expires = expires;
        this.rules = rules;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    @Override
    public List<AccessPointRule> rules() {
        return this.rules;
    }

    public final ImmutableConfigSimple withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableConfigSimple(value, this.date, this.expires, this.rules);
    }

    public final ImmutableConfigSimple withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableConfigSimple(this.identifier, value, this.expires, this.rules);
    }

    public final ImmutableConfigSimple withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableConfigSimple(this.identifier, this.date, value, this.rules);
    }

    public final ImmutableConfigSimple withRules(AccessPointRule ... elements) {
        List<AccessPointRule> newValue = ImmutableConfigSimple.createUnmodifiableList(false, ImmutableConfigSimple.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableConfigSimple(this.identifier, this.date, this.expires, newValue);
    }

    public final ImmutableConfigSimple withRules(Iterable<? extends AccessPointRule> elements) {
        if (this.rules == elements) {
            return this;
        }
        List<AccessPointRule> newValue = ImmutableConfigSimple.createUnmodifiableList(false, ImmutableConfigSimple.createSafeList(elements, true, false));
        return new ImmutableConfigSimple(this.identifier, this.date, this.expires, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfigSimple && this.equalTo(0, (ImmutableConfigSimple)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfigSimple another) {
        return this.identifier == another.identifier && this.date == another.date && this.expires == another.expires && this.rules.equals(another.rules);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.date;
        h += (h << 5) + this.expires;
        h += (h << 5) + this.rules.hashCode();
        return h;
    }

    public String toString() {
        return "ConfigSimple{identifier=" + this.identifier + ", date=" + this.date + ", expires=" + this.expires + ", rules=" + this.rules + "}";
    }

    public static ImmutableConfigSimple of(int date, int expires) {
        return new ImmutableConfigSimple(date, expires);
    }

    public static ImmutableConfigSimple copyOf(ConfigSimple instance) {
        if (instance instanceof ImmutableConfigSimple) {
            return (ImmutableConfigSimple)instance;
        }
        return ImmutableConfigSimple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int date;
        private int expires;
        private List<AccessPointRule> rules = new ArrayList<AccessPointRule>();

        private Builder() {
        }

        public final Builder from(ConfigSimple instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConfigSimple instance;
            long bits = 0L;
            if (object instanceof ConfigSimple) {
                instance = (ConfigSimple)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.expires(instance.expires());
                this.addAllRules(instance.rules());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addRule(AccessPointRule element) {
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder addRules(AccessPointRule ... elements) {
            for (AccessPointRule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(Iterable<? extends AccessPointRule> elements) {
            this.rules.clear();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends AccessPointRule> elements) {
            for (AccessPointRule accessPointRule : elements) {
                this.rules.add(Objects.requireNonNull(accessPointRule, "rules element"));
            }
            return this;
        }

        public ImmutableConfigSimple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfigSimple(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            return "Cannot build ConfigSimple, some of required attributes are not set " + attributes;
        }
    }
}

