/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.Country;
import telegram4j.tl.help.CountryCode;

public final class ImmutableCountry
implements Country {
    private final int identifier;
    private final int flags;
    private final boolean hidden;
    private final String iso2;
    private final String defaultName;
    @Nullable
    private final String name;
    private final List<CountryCode> countryCodes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCountry(String iso2, String defaultName) {
        this.iso2 = Objects.requireNonNull(iso2, "iso2");
        this.defaultName = Objects.requireNonNull(defaultName, "defaultName");
        this.name = null;
        this.countryCodes = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hidden = this.initShim.hidden();
        this.initShim = null;
    }

    private ImmutableCountry(Builder builder) {
        this.iso2 = builder.iso2;
        this.defaultName = builder.defaultName;
        this.name = builder.name;
        this.countryCodes = ImmutableCountry.createUnmodifiableList(true, builder.countryCodes);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.hiddenIsSet()) {
            this.initShim.hidden(builder.hidden);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hidden = this.initShim.hidden();
        this.initShim = null;
    }

    private ImmutableCountry(int identifier, int flags, boolean hidden, String iso2, String defaultName, @Nullable String name, List<CountryCode> countryCodes) {
        this.identifier = identifier;
        this.flags = flags;
        this.hidden = hidden;
        this.iso2 = iso2;
        this.defaultName = defaultName;
        this.name = name;
        this.countryCodes = countryCodes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Country.super.identifier();
    }

    private int flagsInitialize() {
        return Country.super.flags();
    }

    private boolean hiddenInitialize() {
        return Country.super.hidden();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean hidden() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hidden() : this.hidden;
    }

    @Override
    public String iso2() {
        return this.iso2;
    }

    @Override
    public String defaultName() {
        return this.defaultName;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public List<CountryCode> countryCodes() {
        return this.countryCodes;
    }

    public final ImmutableCountry withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCountry(value, this.flags, this.hidden, this.iso2, this.defaultName, this.name, this.countryCodes);
    }

    public final ImmutableCountry withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableCountry(this.identifier, value, this.hidden, this.iso2, this.defaultName, this.name, this.countryCodes);
    }

    public final ImmutableCountry withHidden(boolean value) {
        if (this.hidden == value) {
            return this;
        }
        return new ImmutableCountry(this.identifier, this.flags, value, this.iso2, this.defaultName, this.name, this.countryCodes);
    }

    public final ImmutableCountry withIso2(String value) {
        String newValue = Objects.requireNonNull(value, "iso2");
        if (this.iso2.equals(newValue)) {
            return this;
        }
        return new ImmutableCountry(this.identifier, this.flags, this.hidden, newValue, this.defaultName, this.name, this.countryCodes);
    }

    public final ImmutableCountry withDefaultName(String value) {
        String newValue = Objects.requireNonNull(value, "defaultName");
        if (this.defaultName.equals(newValue)) {
            return this;
        }
        return new ImmutableCountry(this.identifier, this.flags, this.hidden, this.iso2, newValue, this.name, this.countryCodes);
    }

    public final ImmutableCountry withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableCountry(this.identifier, this.flags, this.hidden, this.iso2, this.defaultName, value, this.countryCodes);
    }

    public final ImmutableCountry withCountryCodes(CountryCode ... elements) {
        List<CountryCode> newValue = ImmutableCountry.createUnmodifiableList(false, ImmutableCountry.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCountry(this.identifier, this.flags, this.hidden, this.iso2, this.defaultName, this.name, newValue);
    }

    public final ImmutableCountry withCountryCodes(Iterable<? extends CountryCode> elements) {
        if (this.countryCodes == elements) {
            return this;
        }
        List<CountryCode> newValue = ImmutableCountry.createUnmodifiableList(false, ImmutableCountry.createSafeList(elements, true, false));
        return new ImmutableCountry(this.identifier, this.flags, this.hidden, this.iso2, this.defaultName, this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCountry && this.equalTo(0, (ImmutableCountry)another);
    }

    private boolean equalTo(int synthetic, ImmutableCountry another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.hidden == another.hidden && this.iso2.equals(another.iso2) && this.defaultName.equals(another.defaultName) && Objects.equals(this.name, another.name) && this.countryCodes.equals(another.countryCodes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.hidden);
        h += (h << 5) + this.iso2.hashCode();
        h += (h << 5) + this.defaultName.hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.countryCodes.hashCode();
        return h;
    }

    public String toString() {
        return "Country{identifier=" + this.identifier + ", flags=" + this.flags + ", hidden=" + this.hidden + ", iso2=" + this.iso2 + ", defaultName=" + this.defaultName + ", name=" + this.name + ", countryCodes=" + this.countryCodes + "}";
    }

    public static ImmutableCountry of(String iso2, String defaultName) {
        return new ImmutableCountry(iso2, defaultName);
    }

    public static ImmutableCountry copyOf(Country instance) {
        if (instance instanceof ImmutableCountry) {
            return (ImmutableCountry)instance;
        }
        return ImmutableCountry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ISO2 = 1L;
        private static final long INIT_BIT_DEFAULT_NAME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_HIDDEN = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean hidden;
        private String iso2;
        private String defaultName;
        private String name;
        private List<CountryCode> countryCodes = new ArrayList<CountryCode>();

        private Builder() {
        }

        public final Builder from(Country instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Country instance;
            long bits = 0L;
            if (object instanceof Country) {
                instance = (Country)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllCountryCodes(instance.countryCodes());
                this.hidden(instance.hidden());
                this.flags(instance.flags());
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                this.iso2(instance.iso2());
                this.defaultName(instance.defaultName());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder hidden(boolean hidden) {
            this.hidden = hidden;
            this.optBits |= 4L;
            return this;
        }

        public final Builder iso2(String iso2) {
            this.iso2 = Objects.requireNonNull(iso2, "iso2");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder defaultName(String defaultName) {
            this.defaultName = Objects.requireNonNull(defaultName, "defaultName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder addCountryCode(CountryCode element) {
            this.countryCodes.add(Objects.requireNonNull(element, "countryCodes element"));
            return this;
        }

        public final Builder addCountryCodes(CountryCode ... elements) {
            for (CountryCode element : elements) {
                this.countryCodes.add(Objects.requireNonNull(element, "countryCodes element"));
            }
            return this;
        }

        public final Builder countryCodes(Iterable<? extends CountryCode> elements) {
            this.countryCodes.clear();
            return this.addAllCountryCodes(elements);
        }

        public final Builder addAllCountryCodes(Iterable<? extends CountryCode> elements) {
            for (CountryCode countryCode : elements) {
                this.countryCodes.add(Objects.requireNonNull(countryCode, "countryCodes element"));
            }
            return this;
        }

        public ImmutableCountry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCountry(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hiddenIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("iso2");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("defaultName");
            }
            return "Cannot build Country, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte hiddenBuildStage = 0;
        private boolean hidden;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCountry.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableCountry.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean hidden() {
            if (this.hiddenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hiddenBuildStage == 0) {
                this.hiddenBuildStage = (byte)-1;
                this.hidden = ImmutableCountry.this.hiddenInitialize();
                this.hiddenBuildStage = 1;
            }
            return this.hidden;
        }

        void hidden(boolean hidden) {
            this.hidden = hidden;
            this.hiddenBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.hiddenBuildStage == -1) {
                attributes.add("hidden");
            }
            return "Cannot build Country, attribute initializers form cycle " + attributes;
        }
    }
}

