/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.CountryCode;

public final class ImmutableCountryCode
implements CountryCode {
    private final int identifier;
    private final int flags;
    private final String countryCode;
    @Nullable
    private final List<String> prefixes;
    @Nullable
    private final List<String> patterns;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCountryCode(String countryCode) {
        this.countryCode = Objects.requireNonNull(countryCode, "countryCode");
        this.prefixes = null;
        this.patterns = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableCountryCode(Builder builder) {
        this.countryCode = builder.countryCode;
        this.prefixes = builder.prefixes == null ? null : ImmutableCountryCode.createUnmodifiableList(true, builder.prefixes);
        List<String> list = this.patterns = builder.patterns == null ? null : ImmutableCountryCode.createUnmodifiableList(true, builder.patterns);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableCountryCode(int identifier, int flags, String countryCode, @Nullable List<String> prefixes, @Nullable List<String> patterns) {
        this.identifier = identifier;
        this.flags = flags;
        this.countryCode = countryCode;
        this.prefixes = prefixes;
        this.patterns = patterns;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return CountryCode.super.identifier();
    }

    private int flagsInitialize() {
        return CountryCode.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String countryCode() {
        return this.countryCode;
    }

    @Override
    @Nullable
    public List<String> prefixes() {
        return this.prefixes;
    }

    @Override
    @Nullable
    public List<String> patterns() {
        return this.patterns;
    }

    public final ImmutableCountryCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCountryCode(value, this.flags, this.countryCode, this.prefixes, this.patterns);
    }

    public final ImmutableCountryCode withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableCountryCode(this.identifier, value, this.countryCode, this.prefixes, this.patterns);
    }

    public final ImmutableCountryCode withCountryCode(String value) {
        String newValue = Objects.requireNonNull(value, "countryCode");
        if (this.countryCode.equals(newValue)) {
            return this;
        }
        return new ImmutableCountryCode(this.identifier, this.flags, newValue, this.prefixes, this.patterns);
    }

    public final ImmutableCountryCode withPrefixes(String ... elements) {
        if (elements == null) {
            return new ImmutableCountryCode(this.identifier, this.flags, this.countryCode, null, this.patterns);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableCountryCode.createUnmodifiableList(false, ImmutableCountryCode.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCountryCode(this.identifier, this.flags, this.countryCode, newValue, this.patterns);
    }

    public final ImmutableCountryCode withPrefixes(@Nullable Iterable<String> elements) {
        if (this.prefixes == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableCountryCode.createUnmodifiableList(false, ImmutableCountryCode.createSafeList(elements, true, false));
        return new ImmutableCountryCode(this.identifier, this.flags, this.countryCode, newValue, this.patterns);
    }

    public final ImmutableCountryCode withPatterns(String ... elements) {
        if (elements == null) {
            return new ImmutableCountryCode(this.identifier, this.flags, this.countryCode, this.prefixes, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableCountryCode.createUnmodifiableList(false, ImmutableCountryCode.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCountryCode(this.identifier, this.flags, this.countryCode, this.prefixes, newValue);
    }

    public final ImmutableCountryCode withPatterns(@Nullable Iterable<String> elements) {
        if (this.patterns == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableCountryCode.createUnmodifiableList(false, ImmutableCountryCode.createSafeList(elements, true, false));
        return new ImmutableCountryCode(this.identifier, this.flags, this.countryCode, this.prefixes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCountryCode && this.equalTo(0, (ImmutableCountryCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableCountryCode another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.countryCode.equals(another.countryCode) && Objects.equals(this.prefixes, another.prefixes) && Objects.equals(this.patterns, another.patterns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.countryCode.hashCode();
        h += (h << 5) + Objects.hashCode(this.prefixes);
        h += (h << 5) + Objects.hashCode(this.patterns);
        return h;
    }

    public String toString() {
        return "CountryCode{identifier=" + this.identifier + ", flags=" + this.flags + ", countryCode=" + this.countryCode + ", prefixes=" + this.prefixes + ", patterns=" + this.patterns + "}";
    }

    public static ImmutableCountryCode of(String countryCode) {
        return new ImmutableCountryCode(countryCode);
    }

    public static ImmutableCountryCode copyOf(CountryCode instance) {
        if (instance instanceof ImmutableCountryCode) {
            return (ImmutableCountryCode)instance;
        }
        return ImmutableCountryCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNTRY_CODE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private String countryCode;
        private List<String> prefixes = null;
        private List<String> patterns = null;

        private Builder() {
        }

        public final Builder from(CountryCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CountryCode instance;
            long bits = 0L;
            if (object instanceof CountryCode) {
                List<String> prefixesValue;
                instance = (CountryCode)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((prefixesValue = instance.prefixes()) != null) {
                    this.addAllPrefixes(prefixesValue);
                }
                this.countryCode(instance.countryCode());
                List<String> patternsValue = instance.patterns();
                if (patternsValue != null) {
                    this.addAllPatterns(patternsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder countryCode(String countryCode) {
            this.countryCode = Objects.requireNonNull(countryCode, "countryCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPrefixe(String element) {
            if (this.prefixes == null) {
                this.prefixes = new ArrayList<String>();
            }
            this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            return this;
        }

        public final Builder addPrefixes(String ... elements) {
            if (this.prefixes == null) {
                this.prefixes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            }
            return this;
        }

        public final Builder prefixes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.prefixes = null;
                return this;
            }
            this.prefixes = new ArrayList<String>();
            return this.addAllPrefixes(elements);
        }

        public final Builder addAllPrefixes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "prefixes element");
            if (this.prefixes == null) {
                this.prefixes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            }
            return this;
        }

        public final Builder addPattern(String element) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            this.patterns.add(Objects.requireNonNull(element, "patterns element"));
            return this;
        }

        public final Builder addPatterns(String ... elements) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.patterns.add(Objects.requireNonNull(element, "patterns element"));
            }
            return this;
        }

        public final Builder patterns(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.patterns = null;
                return this;
            }
            this.patterns = new ArrayList<String>();
            return this.addAllPatterns(elements);
        }

        public final Builder addAllPatterns(Iterable<String> elements) {
            Objects.requireNonNull(elements, "patterns element");
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.patterns.add(Objects.requireNonNull(element, "patterns element"));
            }
            return this;
        }

        public ImmutableCountryCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCountryCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("countryCode");
            }
            return "Cannot build CountryCode, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCountryCode.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableCountryCode.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build CountryCode, attribute initializers form cycle " + attributes;
        }
    }
}

