/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.Objects;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.DeepLinkInfo;
import telegram4j.tl.help.DeepLinkInfoEmpty;

public final class ImmutableDeepLinkInfoEmpty
implements DeepLinkInfoEmpty {
    private final int identifier;
    private static final ImmutableDeepLinkInfoEmpty INSTANCE = ImmutableDeepLinkInfoEmpty.validate(new ImmutableDeepLinkInfoEmpty());

    private ImmutableDeepLinkInfoEmpty() {
        this.identifier = DeepLinkInfoEmpty.super.identifier();
    }

    private ImmutableDeepLinkInfoEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : DeepLinkInfoEmpty.super.identifier();
    }

    private ImmutableDeepLinkInfoEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableDeepLinkInfoEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableDeepLinkInfoEmpty.validate(new ImmutableDeepLinkInfoEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeepLinkInfoEmpty && this.equalTo(0, (ImmutableDeepLinkInfoEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeepLinkInfoEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "DeepLinkInfoEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableDeepLinkInfoEmpty of() {
        return INSTANCE;
    }

    private static ImmutableDeepLinkInfoEmpty validate(ImmutableDeepLinkInfoEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableDeepLinkInfoEmpty copyOf(DeepLinkInfoEmpty instance) {
        if (instance instanceof ImmutableDeepLinkInfoEmpty) {
            return (ImmutableDeepLinkInfoEmpty)instance;
        }
        return ImmutableDeepLinkInfoEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeepLinkInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeepLinkInfoEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DeepLinkInfo) {
                instance = (DeepLinkInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DeepLinkInfoEmpty) {
                instance = (DeepLinkInfoEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableDeepLinkInfoEmpty build() {
            return ImmutableDeepLinkInfoEmpty.validate(new ImmutableDeepLinkInfoEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

