/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.InviteText;

public final class ImmutableInviteText
implements InviteText {
    private final int identifier;
    private final String message;

    private ImmutableInviteText(String message) {
        this.message = Objects.requireNonNull(message, "message");
        this.identifier = InviteText.super.identifier();
    }

    private ImmutableInviteText(Builder builder) {
        this.message = builder.message;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InviteText.super.identifier();
    }

    private ImmutableInviteText(int identifier, String message) {
        this.identifier = identifier;
        this.message = message;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String message() {
        return this.message;
    }

    public final ImmutableInviteText withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInviteText(value, this.message);
    }

    public final ImmutableInviteText withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableInviteText(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInviteText && this.equalTo(0, (ImmutableInviteText)another);
    }

    private boolean equalTo(int synthetic, ImmutableInviteText another) {
        return this.identifier == another.identifier && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "InviteText{identifier=" + this.identifier + ", message=" + this.message + "}";
    }

    public static ImmutableInviteText of(String message) {
        return new ImmutableInviteText(message);
    }

    public static ImmutableInviteText copyOf(InviteText instance) {
        if (instance instanceof ImmutableInviteText) {
            return (ImmutableInviteText)instance;
        }
        return ImmutableInviteText.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String message;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InviteText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InviteText) {
                instance = (InviteText)object;
                this.message(instance.message());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInviteText build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInviteText(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build InviteText, some of required attributes are not set " + attributes;
        }
    }
}

