/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.PremiumPromo;

public final class ImmutablePremiumPromo
implements PremiumPromo {
    private final int identifier;
    private final String statusText;
    private final List<MessageEntity> statusEntities;
    private final List<String> videoSections;
    private final List<Document> videos;
    private final String currency;
    private final long monthlyAmount;
    private final List<User> users;

    private ImmutablePremiumPromo(String statusText, String currency, long monthlyAmount) {
        this.statusText = Objects.requireNonNull(statusText, "statusText");
        this.currency = Objects.requireNonNull(currency, "currency");
        this.monthlyAmount = monthlyAmount;
        this.statusEntities = Collections.emptyList();
        this.videoSections = Collections.emptyList();
        this.videos = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = PremiumPromo.super.identifier();
    }

    private ImmutablePremiumPromo(Builder builder) {
        this.statusText = builder.statusText;
        this.statusEntities = ImmutablePremiumPromo.createUnmodifiableList(true, builder.statusEntities);
        this.videoSections = ImmutablePremiumPromo.createUnmodifiableList(true, builder.videoSections);
        this.videos = ImmutablePremiumPromo.createUnmodifiableList(true, builder.videos);
        this.currency = builder.currency;
        this.monthlyAmount = builder.monthlyAmount;
        this.users = ImmutablePremiumPromo.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PremiumPromo.super.identifier();
    }

    private ImmutablePremiumPromo(int identifier, String statusText, List<MessageEntity> statusEntities, List<String> videoSections, List<Document> videos, String currency, long monthlyAmount, List<User> users) {
        this.identifier = identifier;
        this.statusText = statusText;
        this.statusEntities = statusEntities;
        this.videoSections = videoSections;
        this.videos = videos;
        this.currency = currency;
        this.monthlyAmount = monthlyAmount;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String statusText() {
        return this.statusText;
    }

    @Override
    public List<MessageEntity> statusEntities() {
        return this.statusEntities;
    }

    @Override
    public List<String> videoSections() {
        return this.videoSections;
    }

    @Override
    public List<Document> videos() {
        return this.videos;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long monthlyAmount() {
        return this.monthlyAmount;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePremiumPromo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePremiumPromo(value, this.statusText, this.statusEntities, this.videoSections, this.videos, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withStatusText(String value) {
        String newValue = Objects.requireNonNull(value, "statusText");
        if (this.statusText.equals(newValue)) {
            return this;
        }
        return new ImmutablePremiumPromo(this.identifier, newValue, this.statusEntities, this.videoSections, this.videos, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withStatusEntities(MessageEntity ... elements) {
        List<MessageEntity> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, newValue, this.videoSections, this.videos, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withStatusEntities(Iterable<? extends MessageEntity> elements) {
        if (this.statusEntities == elements) {
            return this;
        }
        List<MessageEntity> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(elements, true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, newValue, this.videoSections, this.videos, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withVideoSections(String ... elements) {
        List<String> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, newValue, this.videos, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withVideoSections(Iterable<String> elements) {
        if (this.videoSections == elements) {
            return this;
        }
        List<String> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(elements, true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, newValue, this.videos, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withVideos(Document ... elements) {
        List<Document> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, this.videoSections, newValue, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withVideos(Iterable<? extends Document> elements) {
        if (this.videos == elements) {
            return this;
        }
        List<Document> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(elements, true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, this.videoSections, newValue, this.currency, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, this.videoSections, this.videos, newValue, this.monthlyAmount, this.users);
    }

    public final ImmutablePremiumPromo withMonthlyAmount(long value) {
        if (this.monthlyAmount == value) {
            return this;
        }
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, this.videoSections, this.videos, this.currency, value, this.users);
    }

    public final ImmutablePremiumPromo withUsers(User ... elements) {
        List<User> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, this.videoSections, this.videos, this.currency, this.monthlyAmount, newValue);
    }

    public final ImmutablePremiumPromo withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePremiumPromo.createUnmodifiableList(false, ImmutablePremiumPromo.createSafeList(elements, true, false));
        return new ImmutablePremiumPromo(this.identifier, this.statusText, this.statusEntities, this.videoSections, this.videos, this.currency, this.monthlyAmount, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePremiumPromo && this.equalTo(0, (ImmutablePremiumPromo)another);
    }

    private boolean equalTo(int synthetic, ImmutablePremiumPromo another) {
        return this.identifier == another.identifier && this.statusText.equals(another.statusText) && this.statusEntities.equals(another.statusEntities) && this.videoSections.equals(another.videoSections) && this.videos.equals(another.videos) && this.currency.equals(another.currency) && this.monthlyAmount == another.monthlyAmount && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.statusText.hashCode();
        h += (h << 5) + this.statusEntities.hashCode();
        h += (h << 5) + this.videoSections.hashCode();
        h += (h << 5) + this.videos.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.monthlyAmount);
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PremiumPromo{identifier=" + this.identifier + ", statusText=" + this.statusText + ", statusEntities=" + this.statusEntities + ", videoSections=" + this.videoSections + ", videos=" + this.videos + ", currency=" + this.currency + ", monthlyAmount=" + this.monthlyAmount + ", users=" + this.users + "}";
    }

    public static ImmutablePremiumPromo of(String statusText, String currency, long monthlyAmount) {
        return new ImmutablePremiumPromo(statusText, currency, monthlyAmount);
    }

    public static ImmutablePremiumPromo copyOf(PremiumPromo instance) {
        if (instance instanceof ImmutablePremiumPromo) {
            return (ImmutablePremiumPromo)instance;
        }
        return ImmutablePremiumPromo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATUS_TEXT = 1L;
        private static final long INIT_BIT_CURRENCY = 2L;
        private static final long INIT_BIT_MONTHLY_AMOUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String statusText;
        private List<MessageEntity> statusEntities = new ArrayList<MessageEntity>();
        private List<String> videoSections = new ArrayList<String>();
        private List<Document> videos = new ArrayList<Document>();
        private String currency;
        private long monthlyAmount;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PremiumPromo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PremiumPromo) {
                instance = (PremiumPromo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllVideoSections(instance.videoSections());
                this.statusText(instance.statusText());
                this.addAllVideos(instance.videos());
                this.currency(instance.currency());
                this.monthlyAmount(instance.monthlyAmount());
                this.addAllStatusEntities(instance.statusEntities());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder statusText(String statusText) {
            this.statusText = Objects.requireNonNull(statusText, "statusText");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addStatusEntity(MessageEntity element) {
            this.statusEntities.add(Objects.requireNonNull(element, "statusEntities element"));
            return this;
        }

        public final Builder addStatusEntities(MessageEntity ... elements) {
            for (MessageEntity element : elements) {
                this.statusEntities.add(Objects.requireNonNull(element, "statusEntities element"));
            }
            return this;
        }

        public final Builder statusEntities(Iterable<? extends MessageEntity> elements) {
            this.statusEntities.clear();
            return this.addAllStatusEntities(elements);
        }

        public final Builder addAllStatusEntities(Iterable<? extends MessageEntity> elements) {
            for (MessageEntity messageEntity : elements) {
                this.statusEntities.add(Objects.requireNonNull(messageEntity, "statusEntities element"));
            }
            return this;
        }

        public final Builder addVideoSection(String element) {
            this.videoSections.add(Objects.requireNonNull(element, "videoSections element"));
            return this;
        }

        public final Builder addVideoSections(String ... elements) {
            for (String element : elements) {
                this.videoSections.add(Objects.requireNonNull(element, "videoSections element"));
            }
            return this;
        }

        public final Builder videoSections(Iterable<String> elements) {
            this.videoSections.clear();
            return this.addAllVideoSections(elements);
        }

        public final Builder addAllVideoSections(Iterable<String> elements) {
            for (String element : elements) {
                this.videoSections.add(Objects.requireNonNull(element, "videoSections element"));
            }
            return this;
        }

        public final Builder addVideo(Document element) {
            this.videos.add(Objects.requireNonNull(element, "videos element"));
            return this;
        }

        public final Builder addVideos(Document ... elements) {
            for (Document element : elements) {
                this.videos.add(Objects.requireNonNull(element, "videos element"));
            }
            return this;
        }

        public final Builder videos(Iterable<? extends Document> elements) {
            this.videos.clear();
            return this.addAllVideos(elements);
        }

        public final Builder addAllVideos(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.videos.add(Objects.requireNonNull(document, "videos element"));
            }
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder monthlyAmount(long monthlyAmount) {
            this.monthlyAmount = monthlyAmount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePremiumPromo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePremiumPromo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("statusText");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("monthlyAmount");
            }
            return "Cannot build PremiumPromo, some of required attributes are not set " + attributes;
        }
    }
}

