/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.PromoData;
import telegram4j.tl.help.PromoDataEmpty;

public final class ImmutablePromoDataEmpty
implements PromoDataEmpty {
    private final int identifier;
    private final int expires;

    private ImmutablePromoDataEmpty(int expires) {
        this.expires = expires;
        this.identifier = PromoDataEmpty.super.identifier();
    }

    private ImmutablePromoDataEmpty(Builder builder) {
        this.expires = builder.expires;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PromoDataEmpty.super.identifier();
    }

    private ImmutablePromoDataEmpty(int identifier, int expires) {
        this.identifier = identifier;
        this.expires = expires;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    public final ImmutablePromoDataEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePromoDataEmpty(value, this.expires);
    }

    public final ImmutablePromoDataEmpty withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutablePromoDataEmpty(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePromoDataEmpty && this.equalTo(0, (ImmutablePromoDataEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutablePromoDataEmpty another) {
        return this.identifier == another.identifier && this.expires == another.expires;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.expires;
        return h;
    }

    public String toString() {
        return "PromoDataEmpty{identifier=" + this.identifier + ", expires=" + this.expires + "}";
    }

    public static ImmutablePromoDataEmpty of(int expires) {
        return new ImmutablePromoDataEmpty(expires);
    }

    public static ImmutablePromoDataEmpty copyOf(PromoDataEmpty instance) {
        if (instance instanceof ImmutablePromoDataEmpty) {
            return (ImmutablePromoDataEmpty)instance;
        }
        return ImmutablePromoDataEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXPIRES = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int expires;

        private Builder() {
        }

        public final Builder from(PromoData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PromoDataEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PromoData instance;
            long bits = 0L;
            if (object instanceof PromoData) {
                instance = (PromoData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PromoDataEmpty) {
                instance = (PromoDataEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePromoDataEmpty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePromoDataEmpty(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expires");
            }
            return "Cannot build PromoDataEmpty, some of required attributes are not set " + attributes;
        }
    }
}

