/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.RecentMeUrl;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.RecentMeUrls;

public final class ImmutableRecentMeUrls
implements RecentMeUrls {
    private final int identifier;
    private final List<RecentMeUrl> urls;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableRecentMeUrls(Builder builder) {
        this.urls = ImmutableRecentMeUrls.createUnmodifiableList(true, builder.urls);
        this.chats = ImmutableRecentMeUrls.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableRecentMeUrls.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : RecentMeUrls.super.identifier();
    }

    private ImmutableRecentMeUrls(int identifier, List<RecentMeUrl> urls, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.urls = urls;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<RecentMeUrl> urls() {
        return this.urls;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableRecentMeUrls withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRecentMeUrls(value, this.urls, this.chats, this.users);
    }

    public final ImmutableRecentMeUrls withUrls(RecentMeUrl ... elements) {
        List<RecentMeUrl> newValue = ImmutableRecentMeUrls.createUnmodifiableList(false, ImmutableRecentMeUrls.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRecentMeUrls(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableRecentMeUrls withUrls(Iterable<? extends RecentMeUrl> elements) {
        if (this.urls == elements) {
            return this;
        }
        List<RecentMeUrl> newValue = ImmutableRecentMeUrls.createUnmodifiableList(false, ImmutableRecentMeUrls.createSafeList(elements, true, false));
        return new ImmutableRecentMeUrls(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableRecentMeUrls withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableRecentMeUrls.createUnmodifiableList(false, ImmutableRecentMeUrls.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRecentMeUrls(this.identifier, this.urls, newValue, this.users);
    }

    public final ImmutableRecentMeUrls withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableRecentMeUrls.createUnmodifiableList(false, ImmutableRecentMeUrls.createSafeList(elements, true, false));
        return new ImmutableRecentMeUrls(this.identifier, this.urls, newValue, this.users);
    }

    public final ImmutableRecentMeUrls withUsers(User ... elements) {
        List<User> newValue = ImmutableRecentMeUrls.createUnmodifiableList(false, ImmutableRecentMeUrls.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRecentMeUrls(this.identifier, this.urls, this.chats, newValue);
    }

    public final ImmutableRecentMeUrls withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableRecentMeUrls.createUnmodifiableList(false, ImmutableRecentMeUrls.createSafeList(elements, true, false));
        return new ImmutableRecentMeUrls(this.identifier, this.urls, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecentMeUrls && this.equalTo(0, (ImmutableRecentMeUrls)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecentMeUrls another) {
        return this.identifier == another.identifier && this.urls.equals(another.urls) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.urls.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "RecentMeUrls{identifier=" + this.identifier + ", urls=" + this.urls + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableRecentMeUrls copyOf(RecentMeUrls instance) {
        if (instance instanceof ImmutableRecentMeUrls) {
            return (ImmutableRecentMeUrls)instance;
        }
        return ImmutableRecentMeUrls.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<RecentMeUrl> urls = new ArrayList<RecentMeUrl>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecentMeUrls instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RecentMeUrls) {
                instance = (RecentMeUrls)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUrls(instance.urls());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addUrl(RecentMeUrl element) {
            this.urls.add(Objects.requireNonNull(element, "urls element"));
            return this;
        }

        public final Builder addUrls(RecentMeUrl ... elements) {
            for (RecentMeUrl element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        public final Builder urls(Iterable<? extends RecentMeUrl> elements) {
            this.urls.clear();
            return this.addAllUrls(elements);
        }

        public final Builder addAllUrls(Iterable<? extends RecentMeUrl> elements) {
            for (RecentMeUrl recentMeUrl : elements) {
                this.urls.add(Objects.requireNonNull(recentMeUrl, "urls element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableRecentMeUrls build() {
            return new ImmutableRecentMeUrls(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

