/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.Support;

public final class ImmutableSupport
implements Support {
    private final int identifier;
    private final String phoneNumber;
    private final User user;

    private ImmutableSupport(String phoneNumber, User user) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.user = Objects.requireNonNull(user, "user");
        this.identifier = Support.super.identifier();
    }

    private ImmutableSupport(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.user = builder.user;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Support.super.identifier();
    }

    private ImmutableSupport(int identifier, String phoneNumber, User user) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.user = user;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public User user() {
        return this.user;
    }

    public final ImmutableSupport withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSupport(value, this.phoneNumber, this.user);
    }

    public final ImmutableSupport withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableSupport(this.identifier, newValue, this.user);
    }

    public final ImmutableSupport withUser(User value) {
        if (this.user == value) {
            return this;
        }
        User newValue = Objects.requireNonNull(value, "user");
        return new ImmutableSupport(this.identifier, this.phoneNumber, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSupport && this.equalTo(0, (ImmutableSupport)another);
    }

    private boolean equalTo(int synthetic, ImmutableSupport another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "Support{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", user=" + this.user + "}";
    }

    public static ImmutableSupport of(String phoneNumber, User user) {
        return new ImmutableSupport(phoneNumber, user);
    }

    public static ImmutableSupport copyOf(Support instance) {
        if (instance instanceof ImmutableSupport) {
            return (ImmutableSupport)instance;
        }
        return ImmutableSupport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_USER = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private User user;

        private Builder() {
        }

        public final Builder from(Support instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Support instance;
            long bits = 0L;
            if (object instanceof Support) {
                instance = (Support)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.user(instance.user());
                this.phoneNumber(instance.phoneNumber());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder user(User user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSupport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSupport(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build Support, some of required attributes are not set " + attributes;
        }
    }
}

