/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.SupportName;

public final class ImmutableSupportName
implements SupportName {
    private final int identifier;
    private final String name;

    private ImmutableSupportName(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.identifier = SupportName.super.identifier();
    }

    private ImmutableSupportName(Builder builder) {
        this.name = builder.name;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SupportName.super.identifier();
    }

    private ImmutableSupportName(int identifier, String name) {
        this.identifier = identifier;
        this.name = name;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String name() {
        return this.name;
    }

    public final ImmutableSupportName withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSupportName(value, this.name);
    }

    public final ImmutableSupportName withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSupportName(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSupportName && this.equalTo(0, (ImmutableSupportName)another);
    }

    private boolean equalTo(int synthetic, ImmutableSupportName another) {
        return this.identifier == another.identifier && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "SupportName{identifier=" + this.identifier + ", name=" + this.name + "}";
    }

    public static ImmutableSupportName of(String name) {
        return new ImmutableSupportName(name);
    }

    public static ImmutableSupportName copyOf(SupportName instance) {
        if (instance instanceof ImmutableSupportName) {
            return (ImmutableSupportName)instance;
        }
        return ImmutableSupportName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String name;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SupportName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SupportName) {
                instance = (SupportName)object;
                this.name(instance.name());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSupportName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSupportName(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build SupportName, some of required attributes are not set " + attributes;
        }
    }
}

