/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DataJSON;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.TermsOfService;

public final class ImmutableTermsOfService
implements TermsOfService {
    private final int identifier;
    private final int flags;
    private final boolean popup;
    private final DataJSON id;
    private final String text;
    private final List<MessageEntity> entities;
    @Nullable
    private final Integer minAgeConfirm;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTermsOfService(DataJSON id, String text) {
        this.id = Objects.requireNonNull(id, "id");
        this.text = Objects.requireNonNull(text, "text");
        this.entities = Collections.emptyList();
        this.minAgeConfirm = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.popup = this.initShim.popup();
        this.initShim = null;
    }

    private ImmutableTermsOfService(Builder builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.entities = ImmutableTermsOfService.createUnmodifiableList(true, builder.entities);
        this.minAgeConfirm = builder.minAgeConfirm;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.popupIsSet()) {
            this.initShim.popup(builder.popup);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.popup = this.initShim.popup();
        this.initShim = null;
    }

    private ImmutableTermsOfService(int identifier, int flags, boolean popup, DataJSON id, String text, List<MessageEntity> entities, @Nullable Integer minAgeConfirm) {
        this.identifier = identifier;
        this.flags = flags;
        this.popup = popup;
        this.id = id;
        this.text = text;
        this.entities = entities;
        this.minAgeConfirm = minAgeConfirm;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return TermsOfService.super.identifier();
    }

    private int flagsInitialize() {
        return TermsOfService.super.flags();
    }

    private boolean popupInitialize() {
        return TermsOfService.super.popup();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean popup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.popup() : this.popup;
    }

    @Override
    public DataJSON id() {
        return this.id;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public Integer minAgeConfirm() {
        return this.minAgeConfirm;
    }

    public final ImmutableTermsOfService withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTermsOfService(value, this.flags, this.popup, this.id, this.text, this.entities, this.minAgeConfirm);
    }

    public final ImmutableTermsOfService withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableTermsOfService(this.identifier, value, this.popup, this.id, this.text, this.entities, this.minAgeConfirm);
    }

    public final ImmutableTermsOfService withPopup(boolean value) {
        if (this.popup == value) {
            return this;
        }
        return new ImmutableTermsOfService(this.identifier, this.flags, value, this.id, this.text, this.entities, this.minAgeConfirm);
    }

    public final ImmutableTermsOfService withId(DataJSON value) {
        if (this.id == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "id");
        return new ImmutableTermsOfService(this.identifier, this.flags, this.popup, newValue, this.text, this.entities, this.minAgeConfirm);
    }

    public final ImmutableTermsOfService withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableTermsOfService(this.identifier, this.flags, this.popup, this.id, newValue, this.entities, this.minAgeConfirm);
    }

    public final ImmutableTermsOfService withEntities(MessageEntity ... elements) {
        List<MessageEntity> newValue = ImmutableTermsOfService.createUnmodifiableList(false, ImmutableTermsOfService.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTermsOfService(this.identifier, this.flags, this.popup, this.id, this.text, newValue, this.minAgeConfirm);
    }

    public final ImmutableTermsOfService withEntities(Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = ImmutableTermsOfService.createUnmodifiableList(false, ImmutableTermsOfService.createSafeList(elements, true, false));
        return new ImmutableTermsOfService(this.identifier, this.flags, this.popup, this.id, this.text, newValue, this.minAgeConfirm);
    }

    public final ImmutableTermsOfService withMinAgeConfirm(@Nullable Integer value) {
        if (Objects.equals(this.minAgeConfirm, value)) {
            return this;
        }
        return new ImmutableTermsOfService(this.identifier, this.flags, this.popup, this.id, this.text, this.entities, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTermsOfService && this.equalTo(0, (ImmutableTermsOfService)another);
    }

    private boolean equalTo(int synthetic, ImmutableTermsOfService another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.popup == another.popup && this.id.equals(another.id) && this.text.equals(another.text) && this.entities.equals(another.entities) && Objects.equals(this.minAgeConfirm, another.minAgeConfirm);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.popup);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.entities.hashCode();
        h += (h << 5) + Objects.hashCode(this.minAgeConfirm);
        return h;
    }

    public String toString() {
        return "TermsOfService{identifier=" + this.identifier + ", flags=" + this.flags + ", popup=" + this.popup + ", id=" + this.id + ", text=" + this.text + ", entities=" + this.entities + ", minAgeConfirm=" + this.minAgeConfirm + "}";
    }

    public static ImmutableTermsOfService of(DataJSON id, String text) {
        return new ImmutableTermsOfService(id, text);
    }

    public static ImmutableTermsOfService copyOf(TermsOfService instance) {
        if (instance instanceof ImmutableTermsOfService) {
            return (ImmutableTermsOfService)instance;
        }
        return ImmutableTermsOfService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_POPUP = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean popup;
        private DataJSON id;
        private String text;
        private List<MessageEntity> entities = new ArrayList<MessageEntity>();
        private Integer minAgeConfirm;

        private Builder() {
        }

        public final Builder from(TermsOfService instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TermsOfService instance;
            long bits = 0L;
            if (object instanceof TermsOfService) {
                instance = (TermsOfService)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.popup(instance.popup());
                this.addAllEntities(instance.entities());
                this.flags(instance.flags());
                Integer minAgeConfirmValue = instance.minAgeConfirm();
                if (minAgeConfirmValue != null) {
                    this.minAgeConfirm(minAgeConfirmValue);
                }
                this.id(instance.id());
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder popup(boolean popup) {
            this.popup = popup;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(DataJSON id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(Iterable<? extends MessageEntity> elements) {
            this.entities.clear();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder minAgeConfirm(@Nullable Integer minAgeConfirm) {
            this.minAgeConfirm = minAgeConfirm;
            return this;
        }

        public ImmutableTermsOfService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTermsOfService(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean popupIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build TermsOfService, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte popupBuildStage = 0;
        private boolean popup;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableTermsOfService.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableTermsOfService.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean popup() {
            if (this.popupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.popupBuildStage == 0) {
                this.popupBuildStage = (byte)-1;
                this.popup = ImmutableTermsOfService.this.popupInitialize();
                this.popupBuildStage = 1;
            }
            return this.popup;
        }

        void popup(boolean popup) {
            this.popup = popup;
            this.popupBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.popupBuildStage == -1) {
                attributes.add("popup");
            }
            return "Cannot build TermsOfService, attribute initializers form cycle " + attributes;
        }
    }
}

