/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.help;

import java.util.Objects;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.help.UserInfo;
import telegram4j.tl.help.UserInfoEmpty;

public final class ImmutableUserInfoEmpty
implements UserInfoEmpty {
    private final int identifier;
    private static final ImmutableUserInfoEmpty INSTANCE = ImmutableUserInfoEmpty.validate(new ImmutableUserInfoEmpty());

    private ImmutableUserInfoEmpty() {
        this.identifier = UserInfoEmpty.super.identifier();
    }

    private ImmutableUserInfoEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UserInfoEmpty.super.identifier();
    }

    private ImmutableUserInfoEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUserInfoEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUserInfoEmpty.validate(new ImmutableUserInfoEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserInfoEmpty && this.equalTo(0, (ImmutableUserInfoEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserInfoEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UserInfoEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableUserInfoEmpty of() {
        return INSTANCE;
    }

    private static ImmutableUserInfoEmpty validate(ImmutableUserInfoEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUserInfoEmpty copyOf(UserInfoEmpty instance) {
        if (instance instanceof ImmutableUserInfoEmpty) {
            return (ImmutableUserInfoEmpty)instance;
        }
        return ImmutableUserInfoEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UserInfoEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UserInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UserInfo instance;
            long bits = 0L;
            if (object instanceof UserInfoEmpty) {
                instance = (UserInfoEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UserInfo) {
                instance = (UserInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUserInfoEmpty build() {
            return ImmutableUserInfoEmpty.validate(new ImmutableUserInfoEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

