/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.AffectedFoundMessages;

public final class ImmutableAffectedFoundMessages
implements AffectedFoundMessages {
    private final int identifier;
    private final int pts;
    private final int ptsCount;
    private final int offset;
    private final List<Integer> messages;

    private ImmutableAffectedFoundMessages(int pts, int ptsCount, int offset) {
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.offset = offset;
        this.messages = Collections.emptyList();
        this.identifier = AffectedFoundMessages.super.identifier();
    }

    private ImmutableAffectedFoundMessages(Builder builder) {
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.offset = builder.offset;
        this.messages = ImmutableAffectedFoundMessages.createUnmodifiableList(true, builder.messages);
        this.identifier = builder.identifierIsSet() ? builder.identifier : AffectedFoundMessages.super.identifier();
    }

    private ImmutableAffectedFoundMessages(int identifier, int pts, int ptsCount, int offset, List<Integer> messages) {
        this.identifier = identifier;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.offset = offset;
        this.messages = messages;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public List<Integer> messages() {
        return this.messages;
    }

    public final ImmutableAffectedFoundMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAffectedFoundMessages(value, this.pts, this.ptsCount, this.offset, this.messages);
    }

    public final ImmutableAffectedFoundMessages withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableAffectedFoundMessages(this.identifier, value, this.ptsCount, this.offset, this.messages);
    }

    public final ImmutableAffectedFoundMessages withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableAffectedFoundMessages(this.identifier, this.pts, value, this.offset, this.messages);
    }

    public final ImmutableAffectedFoundMessages withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableAffectedFoundMessages(this.identifier, this.pts, this.ptsCount, value, this.messages);
    }

    public final ImmutableAffectedFoundMessages withMessages(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableAffectedFoundMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableAffectedFoundMessages(this.identifier, this.pts, this.ptsCount, this.offset, newValue);
    }

    public final ImmutableAffectedFoundMessages withMessages(Iterable<Integer> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableAffectedFoundMessages.createUnmodifiableList(false, ImmutableAffectedFoundMessages.createSafeList(elements, true, false));
        return new ImmutableAffectedFoundMessages(this.identifier, this.pts, this.ptsCount, this.offset, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAffectedFoundMessages && this.equalTo(0, (ImmutableAffectedFoundMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableAffectedFoundMessages another) {
        return this.identifier == another.identifier && this.pts == another.pts && this.ptsCount == another.ptsCount && this.offset == another.offset && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        h += (h << 5) + this.offset;
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return "AffectedFoundMessages{identifier=" + this.identifier + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + ", offset=" + this.offset + ", messages=" + this.messages + "}";
    }

    public static ImmutableAffectedFoundMessages of(int pts, int ptsCount, int offset) {
        return new ImmutableAffectedFoundMessages(pts, ptsCount, offset);
    }

    public static ImmutableAffectedFoundMessages copyOf(AffectedFoundMessages instance) {
        if (instance instanceof ImmutableAffectedFoundMessages) {
            return (ImmutableAffectedFoundMessages)instance;
        }
        return ImmutableAffectedFoundMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_PTS_COUNT = 2L;
        private static final long INIT_BIT_OFFSET = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int pts;
        private int ptsCount;
        private int offset;
        private List<Integer> messages = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(AffectedFoundMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AffectedFoundMessages instance;
            long bits = 0L;
            if (object instanceof AffectedFoundMessages) {
                instance = (AffectedFoundMessages)object;
                this.ptsCount(instance.ptsCount());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMessages(instance.messages());
                this.offset(instance.offset());
                this.pts(instance.pts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addMessage(int element) {
            this.messages.add(element);
            return this;
        }

        public final Builder addMessages(int ... elements) {
            for (int element : elements) {
                this.messages.add(element);
            }
            return this;
        }

        public final Builder messages(Iterable<Integer> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public ImmutableAffectedFoundMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAffectedFoundMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ptsCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build AffectedFoundMessages, some of required attributes are not set " + attributes;
        }
    }
}

